/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.stax.ext;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import sqsaml.org.apache.xml.security.exceptions.XMLSecurityException;
import sqsaml.org.apache.xml.security.stax.ext.XMLSecurityConstants;
import sqsaml.org.apache.xml.security.stax.ext.XMLSecurityHeaderHandler;
import sqsaml.org.apache.xml.security.stax.ext.XMLSecurityProperties;
import sqsaml.org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import sqsaml.org.apache.xml.security.stax.impl.XMLSecurityEventReader;

public abstract class AbstractInputSecurityHeaderHandler
implements XMLSecurityHeaderHandler {
    protected <T> T parseStructure(Deque<XMLSecEvent> eventDeque, int index, XMLSecurityProperties securityProperties) throws XMLSecurityException {
        try {
            Unmarshaller unmarshaller = XMLSecurityConstants.getJaxbUnmarshaller(securityProperties.isDisableSchemaValidation());
            return (T)unmarshaller.unmarshal((XMLEventReader)new XMLSecurityEventReader(eventDeque, index));
        }
        catch (JAXBException e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                throw new XMLSecurityException((Exception)e.getCause());
            }
            throw new XMLSecurityException((Exception)((Object)e));
        }
    }

    protected List<QName> getElementPath(Deque<XMLSecEvent> eventDeque) throws XMLSecurityException {
        XMLSecEvent xmlSecEvent = eventDeque.peek();
        return xmlSecEvent.getElementPath();
    }

    protected XMLSecEvent getResponsibleStartXMLEvent(Deque<XMLSecEvent> eventDeque, int index) {
        Iterator<XMLSecEvent> xmlSecEventIterator = eventDeque.descendingIterator();
        int curIdx = 0;
        while (curIdx++ < index) {
            xmlSecEventIterator.next();
        }
        return xmlSecEventIterator.next();
    }

    protected List<XMLSecEvent> getResponsibleXMLSecEvents(Deque<XMLSecEvent> xmlSecEvents, int index) {
        ArrayList<XMLSecEvent> xmlSecEventList = new ArrayList<XMLSecEvent>();
        Iterator<XMLSecEvent> xmlSecEventIterator = xmlSecEvents.descendingIterator();
        int curIdx = 0;
        while (curIdx++ < index && xmlSecEventIterator.hasNext()) {
            xmlSecEventIterator.next();
        }
        while (xmlSecEventIterator.hasNext()) {
            xmlSecEventList.add(xmlSecEventIterator.next());
        }
        return xmlSecEventList;
    }
}

