/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.signature;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import sqsaml.org.apache.xml.security.c14n.CanonicalizationException;
import sqsaml.org.apache.xml.security.parser.XMLParserException;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public class XMLSignatureStreamInput
extends XMLSignatureInput
implements AutoCloseable {
    private InputStream inputStream;

    public XMLSignatureStreamInput(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public boolean hasUnprocessedInput() {
        return this.inputStream != null;
    }

    @Override
    public InputStream getUnprocessedInput() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output, boolean c14n11) throws CanonicalizationException, IOException {
        if (output == this.getOutputStream()) {
            return;
        }
        if (this.hasUnprocessedInput()) {
            byte[] buffer = new byte[8192];
            int bytesread = 0;
            try {
                while ((bytesread = this.inputStream.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesread);
                }
                output.flush();
                return;
            }
            finally {
                this.close();
            }
        }
        this.canonicalize(output, c14n11);
    }

    @Override
    protected Node convertToNode() throws XMLParserException, IOException {
        try {
            Document document;
            block9: {
                InputStream is = this.getUnprocessedInput();
                try {
                    document = XMLUtils.read(is, this.isSecureValidation());
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return document;
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }
}

