/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.signature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import sqsaml.org.apache.xml.security.c14n.CanonicalizationException;
import sqsaml.org.apache.xml.security.parser.XMLParserException;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public class XMLSignatureByteInput
extends XMLSignatureInput {
    private byte[] bytes;

    public XMLSignatureByteInput(byte[] input) {
        this.bytes = input;
    }

    @Override
    public boolean hasUnprocessedInput() {
        return this.bytes != null;
    }

    @Override
    public InputStream getUnprocessedInput() {
        return this.bytes == null ? null : new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void write(OutputStream outputStream, boolean c14n11) throws CanonicalizationException, IOException {
        if (this.bytes == null || outputStream == this.getOutputStream()) {
            return;
        }
        outputStream.write(this.bytes);
        outputStream.flush();
    }

    @Override
    protected Node convertToNode() throws XMLParserException, IOException {
        try {
            Document document = XMLUtils.read(this.getUnprocessedInput(), this.isSecureValidation());
            return document;
        }
        finally {
            this.bytes = null;
        }
    }
}

