/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.encryption.keys;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sqsaml.org.apache.xml.security.encryption.AgreementMethod;
import sqsaml.org.apache.xml.security.encryption.keys.content.AgreementMethodImpl;
import sqsaml.org.apache.xml.security.exceptions.XMLSecurityException;
import sqsaml.org.apache.xml.security.keys.KeyInfo;
import sqsaml.org.apache.xml.security.utils.ElementProxy;
import sqsaml.org.apache.xml.security.utils.I18n;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public class KeyInfoEnc
extends KeyInfo {
    private static final System.Logger LOG = System.getLogger(KeyInfoEnc.class.getName());

    public KeyInfoEnc(Document doc) {
        super(doc);
    }

    public KeyInfoEnc(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public void add(AgreementMethod agreementMethod) {
        if (!(agreementMethod instanceof ElementProxy)) {
            Object[] exArgs = new Object[]{"AgreementMethod", agreementMethod.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", exArgs));
        }
        LOG.log(System.Logger.Level.DEBUG, "Adding agreementMethod with algorithm {0}", agreementMethod.getAlgorithm());
        this.appendSelf((ElementProxy)((Object)agreementMethod));
        this.addReturnToSelf();
    }

    public int lengthAgreementMethod() {
        return this.length("http://www.w3.org/2001/04/xmlenc#", "AgreementMethod");
    }

    public AgreementMethod itemAgreementMethod(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectXencNode(this.getFirstChild(), "AgreementMethod", i);
        if (e == null) {
            LOG.log(System.Logger.Level.WARNING, "No AgreementMethod element at position [{0}]", i);
            return null;
        }
        return new AgreementMethodImpl(e);
    }

    public boolean containsAgreementMethod() {
        return this.lengthAgreementMethod() > 0;
    }
}

