/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import sqsaml.org.apache.velocity.util.introspection.Introspector;
import sqsaml.org.apache.velocity.util.introspection.SecureIntrospectorControl;

public class SecureIntrospectorImpl
extends Introspector
implements SecureIntrospectorControl {
    private String[] badClasses;
    private String[] badPackages;

    public SecureIntrospectorImpl(String[] badClasses, String[] badPackages, Logger log) {
        super(log);
        this.badClasses = badClasses;
        this.badPackages = badPackages;
    }

    @Override
    public Method getMethod(Class<?> clazz, String methodName, Object[] params) throws IllegalArgumentException {
        if (!this.checkObjectExecutePermission(clazz, methodName)) {
            this.log.warn("Cannot retrieve method {} from object of class {} due to security restrictions.", (Object)methodName, (Object)clazz.getName());
            return null;
        }
        return super.getMethod(clazz, methodName, params);
    }

    @Override
    public boolean checkObjectExecutePermission(Class<?> clazz, String methodName) {
        int dotPos;
        if (methodName != null && (methodName.equals("wait") || methodName.equals("notify"))) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Class.class.isAssignableFrom(clazz) && methodName != null && methodName.equals("getName")) {
            return true;
        }
        if (ClassLoader.class.isAssignableFrom(clazz) || Thread.class.isAssignableFrom(clazz)) {
            return false;
        }
        String className = clazz.getName();
        if (className.startsWith("[L") && className.endsWith(";")) {
            className = className.substring(2, className.length() - 1);
        }
        String packageName = (dotPos = className.lastIndexOf(46)) == -1 ? "" : className.substring(0, dotPos);
        for (String badPackage : this.badPackages) {
            if (!packageName.equals(badPackage)) continue;
            return false;
        }
        for (String badClass : this.badClasses) {
            if (!className.equals(badClass)) continue;
            return false;
        }
        return true;
    }
}

