/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import org.xml.sax.helpers.NamespaceSupport;
import sqsaml.nu.xom.Attribute;
import sqsaml.nu.xom.Comment;
import sqsaml.nu.xom.DocType;
import sqsaml.nu.xom.Document;
import sqsaml.nu.xom.EBCDICWriter;
import sqsaml.nu.xom.Element;
import sqsaml.nu.xom.Namespaces;
import sqsaml.nu.xom.Node;
import sqsaml.nu.xom.ParentNode;
import sqsaml.nu.xom.ProcessingInstruction;
import sqsaml.nu.xom.Text;
import sqsaml.nu.xom.TextWriter;
import sqsaml.nu.xom.TextWriterFactory;
import sqsaml.nu.xom.UnicodeWriter;
import sqsaml.nu.xom.UnsynchronizedBufferedWriter;
import sqsaml.nu.xom.XMLException;

public class Serializer {
    private TextWriter escaper;
    private boolean preserveBaseURI = false;
    private NamespaceSupport namespaces = new NamespaceSupport();

    public Serializer(OutputStream outputStream) {
        try {
            this.setOutputStream(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("The VM is broken. It does not understand UTF-8.");
        }
    }

    public Serializer(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("Null encoding");
        }
        this.setOutputStream(outputStream, string);
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        this.flush();
        int n = this.getMaxLength();
        int n2 = this.getIndent();
        String string = this.getLineSeparator();
        boolean bl = this.getUnicodeNormalizationFormC();
        String string2 = this.escaper.getEncoding();
        boolean bl2 = this.escaper.lineSeparatorSet;
        this.setOutputStream(outputStream, string2);
        this.setIndent(n2);
        this.setMaxLength(n);
        this.setUnicodeNormalizationFormC(bl);
        if (bl2) {
            this.setLineSeparator(string);
        }
    }

    private void setOutputStream(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (outputStream == null) {
            throw new NullPointerException("Null OutputStream");
        }
        String string2 = string.toUpperCase(Locale.ENGLISH);
        Writer writer = string2.equals("UTF-8") ? new OutputStreamWriter(outputStream, "UTF-8") : (string2.equals("UTF-16") || string2.equals("ISO-10646-UCS-2") ? new OutputStreamWriter(outputStream, "UnicodeBig") : (string2.equals("IBM037") || string2.equals("CP037") || string2.equals("EBCDIC-CP-US") || string2.equals("EBCDIC-CP-CA") || string2.equals("EBCDIC-CP-WA") || string2.equals("EBCDIC-CP-NL") || string2.equals("CSIBM037") ? new EBCDICWriter(outputStream) : (string2.equals("ISO-8859-11") || string2.equals("TIS-620") ? new OutputStreamWriter(outputStream, "TIS620") : new OutputStreamWriter(outputStream, string))));
        writer = new UnsynchronizedBufferedWriter(writer);
        this.escaper = TextWriterFactory.getTextWriter(writer, string);
    }

    public void write(Document document) throws IOException {
        this.escaper.reset();
        this.namespaces.reset();
        this.namespaces.declarePrefix("", "");
        this.writeXMLDeclaration();
        int n = document.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.writeChild(document.getChild(i));
            this.escaper.breakLine();
        }
        this.escaper.flush();
    }

    protected void writeXMLDeclaration() throws IOException {
        this.escaper.writeUncheckedMarkup("<?xml version=\"1.0\" encoding=\"");
        this.escaper.writeUncheckedMarkup(this.escaper.getEncoding());
        this.escaper.writeUncheckedMarkup("\"?>");
        this.escaper.breakLine();
    }

    protected void write(Element element) throws IOException {
        Node node;
        int n;
        boolean bl = false;
        int n2 = element.getChildCount();
        for (n = 0; n < n2; ++n) {
            Node node2 = element.getChild(n);
            if (node2.isText() && ((Text)(node = (Text)node2)).isEmpty()) continue;
            bl = true;
            break;
        }
        if (bl) {
            n = this.escaper.isPreserveSpace() ? 1 : 0;
            this.writeStartTag(element);
            for (int i = 0; i < n2; ++i) {
                node = element.getChild(i);
                if (this.escaper.getNFC() && node.isText()) {
                    Node node3;
                    Text text = (Text)node;
                    while (i < n2 - 1 && (node3 = element.getChild(i + 1)).isText()) {
                        text = new Text(text.getValue() + node3.getValue());
                        ++i;
                    }
                    this.writeChild(text);
                    continue;
                }
                this.writeChild(node);
            }
            this.writeEndTag(element);
            this.escaper.setPreserveSpace(n != 0);
        } else {
            this.writeEmptyElementTag(element);
        }
    }

    private boolean hasNonTextChildren(Element element) {
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (element.getChild(i).isText()) continue;
            return true;
        }
        return false;
    }

    protected void writeEndTag(Element element) throws IOException {
        this.escaper.decrementIndent();
        if (this.escaper.getIndent() > 0 && !this.escaper.isPreserveSpace() && this.hasNonTextChildren(element)) {
            this.escaper.breakLine();
        }
        this.escaper.write('<');
        this.escaper.write('/');
        this.escaper.writeName(element.getQualifiedName());
        this.escaper.write('>');
        this.namespaces.popContext();
    }

    protected void writeStartTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.write('>');
        this.escaper.incrementIndent();
        String string = element.getAttributeValue("space", "http://www.w3.org/XML/1998/namespace");
        if (string != null) {
            if ("preserve".equals(string)) {
                this.escaper.setPreserveSpace(true);
            } else if ("default".equals(string)) {
                this.escaper.setPreserveSpace(false);
            }
        }
    }

    protected void writeEmptyElementTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.write('/');
        this.escaper.write('>');
        this.namespaces.popContext();
    }

    private void writeTagBeginning(Element element) throws IOException {
        this.namespaces.pushContext();
        if (this.escaper.isIndenting() && !this.escaper.isPreserveSpace() && !this.escaper.justBroke()) {
            this.escaper.breakLine();
        }
        this.escaper.write('<');
        this.escaper.writeName(element.getQualifiedName());
        this.writeAttributes(element);
        this.writeNamespaceDeclarations(element);
    }

    protected void writeAttributes(Element element) throws IOException {
        Attribute attribute;
        if (this.preserveBaseURI) {
            ParentNode parentNode = element.getParent();
            if (element.getAttribute("base", "http://www.w3.org/XML/1998/namespace") == null) {
                String string = element.getBaseURI();
                if (parentNode == null || parentNode.isDocument() || !element.getBaseURI().equals(parentNode.getBaseURI())) {
                    this.escaper.write(' ');
                    attribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string);
                    this.write(attribute);
                }
            }
        }
        int n = element.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            attribute = element.getAttribute(i);
            this.escaper.write(' ');
            this.write(attribute);
        }
    }

    protected void writeNamespaceDeclarations(Element element) throws IOException {
        String string = element.getNamespacePrefix();
        if (!"xml".equals(string)) {
            this.writeNamespaceDeclarationIfNecessary(string, element.getNamespaceURI());
        }
        int n = element.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = element.getAttribute(i);
            String string2 = attribute.getNamespacePrefix();
            if (string2.length() == 0 || "xml".equals(string2)) continue;
            this.writeNamespaceDeclarationIfNecessary(string2, attribute.getNamespaceURI());
        }
        Namespaces namespaces = element.namespaces;
        if (namespaces == null) {
            return;
        }
        int n2 = namespaces.size();
        for (int i = 0; i < n2; ++i) {
            String string3 = namespaces.getPrefix(i);
            String string4 = namespaces.getURI(string3);
            this.writeNamespaceDeclarationIfNecessary(string3, string4);
        }
    }

    private void writeNamespaceDeclarationIfNecessary(String string, String string2) throws IOException {
        String string3 = this.namespaces.getURI(string);
        if (string3 == null && "".equals(string2)) {
            return;
        }
        if (string2.equals(string3)) {
            return;
        }
        this.escaper.write(' ');
        this.writeNamespaceDeclaration(string, string2);
    }

    protected void writeNamespaceDeclaration(String string, String string2) throws IOException {
        this.namespaces.declarePrefix(string, string2);
        if ("".equals(string)) {
            this.escaper.writeUncheckedMarkup("xmlns");
        } else {
            this.escaper.writeUncheckedMarkup("xmlns:");
            this.escaper.writeName(string);
        }
        this.escaper.write('=');
        this.escaper.write('\"');
        this.escaper.writePCDATA(string2);
        this.escaper.write('\"');
    }

    protected void write(Attribute attribute) throws IOException {
        this.escaper.writeName(attribute.getQualifiedName());
        this.escaper.write('=');
        this.escaper.write('\"');
        this.escaper.writeAttributeValue(attribute.getValue());
        this.escaper.write('\"');
    }

    protected void write(Comment comment) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeUncheckedMarkup("<!--");
        this.escaper.writeMarkup(comment.getValue());
        this.escaper.writeUncheckedMarkup("-->");
    }

    protected void write(ProcessingInstruction processingInstruction) throws IOException {
        if (this.escaper.isIndenting()) {
            this.escaper.breakLine();
        }
        this.escaper.writeUncheckedMarkup("<?");
        this.escaper.writeName(processingInstruction.getTarget());
        String string = processingInstruction.getValue();
        if (!"".equals(string)) {
            this.escaper.write(' ');
            this.escaper.writeMarkup(string);
        }
        this.escaper.writeUncheckedMarkup("?>");
    }

    protected void write(Text text) throws IOException {
        String string = text.getValue();
        if (text.isCDATASection() && string.indexOf("]]>") == -1) {
            if (!(this.escaper instanceof UnicodeWriter)) {
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    if (!this.escaper.needsEscaping(string.charAt(i))) continue;
                    this.escaper.writePCDATA(string);
                    return;
                }
            }
            this.escaper.writeUncheckedMarkup("<![CDATA[");
            this.escaper.writeMarkup(string);
            this.escaper.writeUncheckedMarkup("]]>");
        } else {
            if (this.isBoundaryWhitespace(text, string)) {
                return;
            }
            this.escaper.writePCDATA(string);
        }
    }

    private boolean isBoundaryWhitespace(Text text, String string) {
        if (this.getIndent() <= 0) {
            return false;
        }
        ParentNode parentNode = text.getParent();
        if (parentNode == null) {
            return "".equals(string.trim());
        }
        int n = parentNode.getChildCount();
        if (n == 1) {
            return false;
        }
        if (!"".equals(string.trim())) {
            return false;
        }
        int n2 = parentNode.indexOf(text);
        Node node = null;
        Node node2 = null;
        if (n2 != 0) {
            node = parentNode.getChild(n2 - 1);
        }
        if (n2 != n - 1) {
            node2 = parentNode.getChild(n2 + 1);
        }
        return !(node != null && node.isText() || node2 != null && node2.isText());
    }

    protected void write(DocType docType) throws IOException {
        this.escaper.writeUncheckedMarkup("<!DOCTYPE ");
        this.escaper.writeName(docType.getRootElementName());
        if (docType.getPublicID() != null) {
            this.escaper.writeMarkup(" PUBLIC \"" + docType.getPublicID() + "\" \"" + docType.getSystemID() + "\"");
        } else if (docType.getSystemID() != null) {
            this.escaper.writeMarkup(" SYSTEM \"" + docType.getSystemID() + "\"");
        }
        String string = docType.getInternalDTDSubset();
        if (!string.equals("")) {
            this.escaper.writeUncheckedMarkup(" [");
            this.escaper.breakLine();
            this.escaper.setInDocType(true);
            this.escaper.writeMarkup(string);
            this.escaper.setInDocType(false);
            this.escaper.write(']');
        }
        this.escaper.write('>');
    }

    protected void writeChild(Node node) throws IOException {
        if (node.isElement()) {
            this.write((Element)node);
        } else if (node.isText()) {
            this.write((Text)node);
        } else if (node.isComment()) {
            this.write((Comment)node);
        } else if (node.isProcessingInstruction()) {
            this.write((ProcessingInstruction)node);
        } else if (node.isDocType()) {
            this.write((DocType)node);
        } else {
            throw new XMLException("Cannot write a " + node.getClass().getName() + " from the writeChild() method");
        }
    }

    protected final void writeEscaped(String string) throws IOException {
        this.escaper.writePCDATA(string);
    }

    protected final void writeAttributeValue(String string) throws IOException {
        this.escaper.writeAttributeValue(string);
    }

    protected final void writeRaw(String string) throws IOException {
        this.escaper.writeMarkup(string);
    }

    protected final void breakLine() throws IOException {
        this.escaper.breakLine();
    }

    public void flush() throws IOException {
        this.escaper.flush();
    }

    public int getIndent() {
        return this.escaper.getIndent();
    }

    public void setIndent(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Indent cannot be negative");
        }
        this.escaper.setIndent(n);
    }

    public String getLineSeparator() {
        return this.escaper.getLineSeparator();
    }

    public void setLineSeparator(String string) {
        this.escaper.setLineSeparator(string);
    }

    public int getMaxLength() {
        return this.escaper.getMaxLength();
    }

    public void setMaxLength(int n) {
        this.escaper.setMaxLength(n);
    }

    public boolean getPreserveBaseURI() {
        return this.preserveBaseURI;
    }

    public void setPreserveBaseURI(boolean bl) {
        this.preserveBaseURI = bl;
    }

    public String getEncoding() {
        return this.escaper.getEncoding();
    }

    public void setUnicodeNormalizationFormC(boolean bl) {
        this.escaper.setNFC(bl);
    }

    public boolean getUnicodeNormalizationFormC() {
        return this.escaper.getNFC();
    }

    protected final int getColumnNumber() {
        return this.escaper.getColumnNumber();
    }
}

