/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.properties;

import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.saml.SAMLActivationSwitch;

@Component
@ConfigurationPropertiesBinding
@SAMLActivationSwitch
public class StringToAuthnComparisonConverter
implements Converter<String, AuthnContextComparisonTypeEnumeration> {
    public AuthnContextComparisonTypeEnumeration convert(String source) {
        String cleanSrc;
        return switch (cleanSrc = StringUtils.isBlank((CharSequence)source) ? "EXACT" : source.toUpperCase()) {
            case "EXACT" -> AuthnContextComparisonTypeEnumeration.EXACT;
            case "MINIMUM" -> AuthnContextComparisonTypeEnumeration.MINIMUM;
            case "MAXIMUM" -> AuthnContextComparisonTypeEnumeration.MAXIMUM;
            case "BETTER" -> AuthnContextComparisonTypeEnumeration.BETTER;
            default -> throw new IllegalArgumentException("SAML configuration: unknown Authentication comparison '" + source + "'");
        };
    }
}

