/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.squashtest.tm.plugin.saml.properties.DefaultWebSSOProfileOptions;
import org.squashtest.tm.plugin.saml.properties.IDPProperties;
import org.squashtest.tm.plugin.saml.properties.KeystoreProperties;
import org.squashtest.tm.plugin.saml.properties.PropertiesValidator;
import org.squashtest.tm.plugin.saml.properties.ReverseProxyProperties;
import org.squashtest.tm.plugin.saml.properties.SPProperties;
import org.squashtest.tm.plugin.saml.properties.SessionProperties;
import org.squashtest.tm.plugin.saml.properties.UserMappingProperties;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileOptions;

@ConfigurationProperties(value="saml")
@Validated
public class SAMLProperties
implements Validator {
    private boolean enabled = true;
    private KeystoreProperties keystore = new KeystoreProperties();
    private IDPProperties idp = new IDPProperties();
    private SPProperties sp = new SPProperties();
    private WebSSOProfileOptions sso = new DefaultWebSSOProfileOptions();
    private SessionProperties session = new SessionProperties();
    private ReverseProxyProperties proxy = new ReverseProxyProperties();
    private UserMappingProperties userMapping = new UserMappingProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public KeystoreProperties getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeystoreProperties keystore) {
        this.keystore = keystore;
    }

    public IDPProperties getIdp() {
        return this.idp;
    }

    public void setIdp(IDPProperties idp) {
        this.idp = idp;
    }

    public SPProperties getSp() {
        return this.sp;
    }

    public void setSp(SPProperties sp) {
        this.sp = sp;
    }

    public WebSSOProfileOptions getSso() {
        return this.sso;
    }

    public void setSso(WebSSOProfileOptions sso) {
        this.sso = sso;
    }

    public SessionProperties getSession() {
        return this.session;
    }

    public void setSession(SessionProperties session) {
        this.session = session;
    }

    public ReverseProxyProperties getProxy() {
        return this.proxy;
    }

    public void setProxy(ReverseProxyProperties proxy) {
        this.proxy = proxy;
    }

    public UserMappingProperties getUserMapping() {
        return this.userMapping;
    }

    public void setUserMapping(UserMappingProperties userMapping) {
        this.userMapping = userMapping;
    }

    public boolean supports(Class<?> clazz) {
        return clazz == SAMLProperties.class;
    }

    public void validate(Object target, Errors errors) {
        new PropertiesValidator(target, errors).validate();
    }
}

