/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ldap;

import javax.inject.Inject;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.api.security.authentication.FeaturesAwareAuthentication;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.security.ldap.AbstractLdapAuthenticationProviderFeatures;
import org.squashtest.tm.service.user.UserManagerService;

public class SquashLdapAuthenticationProvider
extends LdapAuthenticationProvider {
    @Inject
    private AbstractLdapAuthenticationProviderFeatures features;
    private UserManagerService userFinder;

    public SquashLdapAuthenticationProvider(LdapAuthenticator authenticator) {
        super(authenticator);
    }

    public SquashLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        super(authenticator, authoritiesPopulator);
    }

    public AbstractLdapAuthenticationProviderFeatures getFeatures() {
        return this.features;
    }

    public void setFeatures(AbstractLdapAuthenticationProviderFeatures features) {
        this.features = features;
    }

    public void setUserFinder(UserManagerService userFinder) {
        this.userFinder = userFinder;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        LdapUserDetails userDetails;
        User squashUser;
        Authentication auth = super.authenticate(authentication);
        if (auth.isAuthenticated() && (squashUser = this.userFinder.findByLogin((userDetails = (LdapUserDetails)auth.getPrincipal()).getUsername())) != null && !squashUser.getActive().booleanValue()) {
            throw new BadCredentialsException("User is not active");
        }
        return new FeatureAwareLdapAuthenticationToken((UsernamePasswordAuthenticationToken)auth, this.features);
    }

    public static final class FeatureAwareLdapAuthenticationToken
    extends UsernamePasswordAuthenticationToken
    implements FeaturesAwareAuthentication {
        private static final long serialVersionUID = 1L;
        private AuthenticationProviderFeatures features;

        public FeatureAwareLdapAuthenticationToken(UsernamePasswordAuthenticationToken token, AuthenticationProviderFeatures features) {
            super(token.getPrincipal(), token.getCredentials(), token.getAuthorities());
            this.features = features;
        }

        public AuthenticationProviderFeatures getFeatures() {
            return this.features;
        }
    }
}

