/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ldap;

import java.util.Collection;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.user.UserManagerService;

@Component(value="caseAwareUserDetailsMapper.ldap")
public class CaseAwareUserDetailsMapper
implements UserDetailsContextMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseAwareUserDetailsMapper.class);
    @Inject
    @Lazy
    private FeatureManager features;
    @Inject
    @Lazy
    private UserManagerService userFinder;
    private LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        String actualUsername = username;
        if (this.features.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN)) {
            String found = this.userFinder.findCaseAwareLogin(username);
            LOGGER.debug("Case insensitive login : input '{}' login matches '{}' DB user ", (Object)username, (Object)found);
            actualUsername = found != null ? found : actualUsername;
        }
        return this.mapper.mapUserFromContext(ctx, actualUsername, authorities);
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        this.mapper.mapUserToContext(user, ctx);
    }
}

