/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.helpers;

import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.redminereq.exceptions.YAMLParseException;
import org.squashtest.tm.plugin.redminereq.service.ValueMappings;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.scanner.ScannerException;

@Component(value="org.squashtest.tm.plugin.redminereq.helpers.ValueMappingsYamlDeserializer")
public class ValueMappingsYamlDeserializer {
    private static final String INVALID_MAPPING_MESSAGE_CODE = "henix.redminereq.valuemappings.invalid";
    @Inject
    private InternationalizationHelper inHelper;

    public ValueMappings deserialize(String yamlString) {
        if (StringUtils.isBlank((CharSequence)yamlString)) {
            return new ValueMappings();
        }
        Map<String, Map<String, String>> parsed = this.parseYaml(yamlString);
        this.validateYamlStructure(parsed);
        return new ValueMappings((Map<? extends String, ? extends Map<String, String>>)parsed);
    }

    private Map<String, Map<String, String>> parseYaml(String yamlString) throws ScannerException {
        try {
            return (Map)new Yaml().load(yamlString);
        }
        catch (ClassCastException classCastException) {
            RootTypeException rootTypeException = new RootTypeException(classCastException);
            throw this.buildYAMLParseException("Expected a dictionary at root.", rootTypeException);
        }
        catch (ParserException | ScannerException exception) {
            throw this.buildYAMLParseException(exception.getMessage(), (Exception)exception);
        }
    }

    private void validateYamlStructure(Map<String, Map<String, String>> parsed) {
        try {
            for (String key : parsed.keySet()) {
                this.validateInnerMap(parsed, key);
            }
        }
        catch (ClassCastException classCastException) {
            throw this.buildYAMLParseException("Expected a dictionary with keys of type 'string' at root.", new DictKeyTypeException(classCastException));
        }
    }

    private void validateInnerMap(Map<String, Map<String, String>> parsed, String key) {
        try {
            Map<String, String> innerMap = parsed.get(key);
            if (innerMap == null) {
                throw this.buildYAMLParseException(String.format("Expected a dictionary at '%s'.", key), new DictValueTypeException(null));
            }
            this.validateInnerMapEntries(key, innerMap);
        }
        catch (ClassCastException classCastException) {
            throw this.buildYAMLParseException(String.format("Expected a dictionary at '%s'.", key), new DictValueTypeException(classCastException));
        }
    }

    private void validateInnerMapEntries(String key, Map<String, String> innerMap) {
        try {
            for (String innerKey : innerMap.keySet()) {
                this.validateInnerMapValue(key, innerMap, innerKey);
            }
        }
        catch (ClassCastException classCastException) {
            throw this.buildYAMLParseException(String.format("Expected a dictionary with keys of type 'string' at '%s'.", key), new DictKeyTypeException(classCastException));
        }
    }

    private void validateInnerMapValue(String key, Map<String, String> innerMap, String innerKey) {
        try {
            String value = innerMap.get(innerKey);
            if (value == null) {
                throw this.buildYAMLParseException(String.format("Expected a string at '%s.%s'.", key, innerKey), new DictValueTypeException(null));
            }
        }
        catch (ClassCastException classCastException) {
            throw this.buildYAMLParseException(String.format("Expected a string at '%s.%s'.", key, innerKey), new DictValueTypeException(classCastException));
        }
    }

    private YAMLParseException buildYAMLParseException(String parseError, Exception source) {
        String msg = this.inHelper.getMessage(INVALID_MAPPING_MESSAGE_CODE, null, "Value mapping is invalid, check again your YAML syntax", LocaleContextHolder.getLocale());
        return new YAMLParseException(msg, new String[]{parseError}, msg, source);
    }

    public static class DictKeyTypeException
    extends Exception {
        DictKeyTypeException(Exception source) {
            super(source);
        }
    }

    public static class DictValueTypeException
    extends Exception {
        DictValueTypeException(Exception source) {
            super(source);
        }
    }

    public static class RootTypeException
    extends Exception {
        RootTypeException(Exception source) {
            super(source);
        }
    }
}

