/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.plugin.redminereq.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.redminereq.service.ValueMappings;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Component(value="squash.tm.plugin.redminereq.techDataDictionary")
@Scope(value="prototype")
public class TechnicalDataDictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(TechnicalDataDictionary.class);
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";
    private static final String STR_YES = "yes";
    private static final String STR_NO = "no";
    private static final String BOOL_DIGIT_WILDCARD = "(any non-0 digit)";
    private static final String[] CATEGORY_CODES = new String[]{"CAT_BUSINESS", "CAT_ERGONOMIC", "CAT_FUNCTIONAL", "CAT_NON_FUNCTIONAL", "CAT_PERFORMANCE", "CAT_SECURITY", "CAT_TECHNICAL", "CAT_TEST_REQUIREMENT", "CAT_UNDEFINED", "CAT_UNKNOWN", "CAT_USER_STORY", "CAT_USE_CASE"};
    private static final String CATEGORY_LANG_PREFIX = "requirement.category.";
    private static final String CRICIC_LANG_PREFIX = "requirement.criticality.";
    private static final String STATUS_LANG_PREFIX = "requirement.status.";
    @Inject
    private InternationalizationHelper lang;
    @Inject
    private CustomFieldBindingFinderService cufservice;
    private ValueMappings valueMappings = new ValueMappings();
    private Locale locale = LocaleContextHolder.getLocale();
    private Map<String, ListItemReference> categoriesByLabelOrCode = new HashMap<String, ListItemReference>();
    private Map<String, RequirementCriticality> criticByLabelOrCode = new HashMap<String, RequirementCriticality>();
    private Map<String, RequirementStatus> statusByLabelOrCode = new HashMap<String, RequirementStatus>();
    private Map<String, InputType> customfieldTypesByCode = new HashMap<String, InputType>();
    private Map<String, String> customFieldDefaultsByCode = new HashMap<String, String>();
    private Map<String, Map<String, String>> cufOptionByLabelOrCode = new HashMap<String, Map<String, String>>();
    private Map<String, String> booleanByAnymean = new HashMap<String, String>();

    TechnicalDataDictionary() {
    }

    ListItemReference lookupCategory(String needle) {
        if (needle == null) {
            return null;
        }
        return this.categoriesByLabelOrCode.get(needle.toLowerCase());
    }

    RequirementCriticality lookupCriticity(String needle) {
        if (needle == null) {
            return null;
        }
        return this.criticByLabelOrCode.get(needle.toLowerCase());
    }

    RequirementStatus lookupStatus(String needle) {
        if (needle == null) {
            return null;
        }
        return this.statusByLabelOrCode.get(needle.toLowerCase());
    }

    InputType lookupCufType(String cufcode) {
        if (cufcode == null) {
            return null;
        }
        return this.customfieldTypesByCode.get(cufcode.toLowerCase());
    }

    String lookupDefault(String cufcode) {
        if (cufcode == null) {
            return null;
        }
        return this.customFieldDefaultsByCode.get(cufcode.toLowerCase());
    }

    String lookupItemCode(String cufcode, String option) {
        if (cufcode == null || this.cufOptionByLabelOrCode.get(cufcode.toLowerCase()) == null || this.cufOptionByLabelOrCode.get(cufcode.toLowerCase()).size() == 0) {
            return null;
        }
        return option;
    }

    String lookupBoolean(String needle) {
        if (needle == null) {
            return null;
        }
        String val = this.booleanByAnymean.get(needle);
        if (val == null) {
            try {
                int parsed = Integer.parseInt(needle);
                if (parsed != 0) {
                    return STR_TRUE;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return val;
    }

    void initForProject(Project project, ValueMappings valueMappings) {
        this.valueMappings = this.sanitizedMappings(valueMappings);
        this.initCriticalities();
        this.initStatuses();
        this.initCategories(project.getRequirementCategories());
        this.initCustomfields(project.getId());
        this.initBooleans();
    }

    public ValueMappings sanitizedMappings(ValueMappings mappings) {
        try {
            ValueMappings sanitized = new ValueMappings();
            for (Map.Entry entry : mappings.entrySet()) {
                sanitized.put(((String)entry.getKey()).toLowerCase(), (Map)entry.getValue());
            }
            return sanitized;
        }
        catch (ClassCastException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            String parseError = ex.getMessage();
            String msg = this.lang.getMessage("henix.redminereq.valuemappings.invalid", new Object[]{parseError}, "Value mapping is invalid, check again your YAML syntax", LocaleContextHolder.getLocale());
            throw new PluginValidationException(msg);
        }
    }

    private void initCriticalities() {
        RequirementCriticality[] requirementCriticalityArray = RequirementCriticality.values();
        int n = requirementCriticalityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RequirementCriticality crit = requirementCriticalityArray[n2];
            this.criticByLabelOrCode.put(this.lang.internationalize(CRICIC_LANG_PREFIX + crit.name(), this.locale).toLowerCase(), crit);
            this.criticByLabelOrCode.put(crit.toString().toLowerCase(), crit);
            ++n2;
        }
        String critKey = BuiltinSquashField.CRITICALITY.toString().toLowerCase();
        Map specificMappings = (Map)this.valueMappings.get(critKey);
        if (specificMappings != null) {
            for (Map.Entry entry : specificMappings.entrySet()) {
                try {
                    String redmineName = ((String)entry.getKey()).toLowerCase();
                    RequirementCriticality crit = RequirementCriticality.valueOf((String)((String)entry.getValue()).toUpperCase());
                    this.criticByLabelOrCode.put(redmineName, crit);
                }
                catch (IllegalArgumentException | NullPointerException ex) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("field value mappings : could not find RequirementCriticality with name : " + (String)entry.getValue(), (Throwable)ex);
                }
            }
        }
    }

    private void initCategories(InfoList categories) {
        if ("DEF_REQ_CAT".equals(categories.getCode())) {
            String[] stringArray = CATEGORY_CODES;
            int n = CATEGORY_CODES.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                ListItemReference ref = new ListItemReference(code);
                this.categoriesByLabelOrCode.put(this.lang.internationalize(CATEGORY_LANG_PREFIX + code, this.locale).toLowerCase(), ref);
                this.categoriesByLabelOrCode.put(code.toLowerCase(), ref);
                ++n2;
            }
        } else {
            for (InfoListItem item : categories.getItems()) {
                ListItemReference ref = new ListItemReference(item.getCode());
                this.categoriesByLabelOrCode.put(item.getLabel().toLowerCase(), ref);
                this.categoriesByLabelOrCode.put(item.getCode().toLowerCase(), ref);
            }
        }
        String catKey = BuiltinSquashField.CATEGORY.toString().toLowerCase();
        Map specificMappings = (Map)this.valueMappings.get(catKey);
        boolean isDefault = "DEF_REQ_CAT".equals(categories.getCode());
        if (specificMappings != null) {
            for (Map.Entry entry : specificMappings.entrySet()) {
                String redmineName = ((String)entry.getKey()).toLowerCase();
                String squashName = isDefault ? ((String)entry.getValue()).toUpperCase() : (String)entry.getValue();
                ListItemReference ref = new ListItemReference(squashName);
                this.categoriesByLabelOrCode.put(redmineName, ref);
            }
        }
    }

    private void initStatuses() {
        RequirementStatus[] requirementStatusArray = RequirementStatus.values();
        int n = requirementStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            RequirementStatus status = requirementStatusArray[n2];
            this.statusByLabelOrCode.put(this.lang.internationalize(STATUS_LANG_PREFIX + status.name(), this.locale).toLowerCase(), status);
            this.statusByLabelOrCode.put(status.toString().toLowerCase(), status);
            ++n2;
        }
        String statusKey = BuiltinSquashField.STATUS.toString().toLowerCase();
        Map specificMappings = (Map)this.valueMappings.get(statusKey);
        if (specificMappings != null) {
            for (Map.Entry entry : specificMappings.entrySet()) {
                try {
                    String redmineName = ((String)entry.getKey()).toLowerCase();
                    RequirementStatus status = RequirementStatus.valueOf((String)((String)entry.getValue()).toUpperCase());
                    this.statusByLabelOrCode.put(redmineName, status);
                }
                catch (IllegalArgumentException | NullPointerException ex) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("field value mappings : could not find a RequirementStatus with name : " + (String)entry.getValue(), (Throwable)ex);
                }
            }
        }
    }

    private void initCustomfields(Long projectId) {
        List cufs = this.cufservice.findBoundCustomFields(projectId.longValue(), BindableEntity.REQUIREMENT_VERSION);
        for (CustomField cuf : cufs) {
            InputType type = cuf.getInputType();
            String cufcode = cuf.getCode();
            this.customfieldTypesByCode.put(cufcode.toLowerCase(), type);
            if (type != InputType.DROPDOWN_LIST) continue;
            this.customFieldDefaultsByCode.put(cufcode.toLowerCase(), cuf.getDefaultValue());
            List options = ((SingleSelectField)cuf).getOptions();
            HashMap<String, String> optioncodes = new HashMap<String, String>();
            for (CustomFieldOption opt : options) {
                String label = opt.getLabel();
                String ocode = opt.getCode();
                optioncodes.put(cufcode.toLowerCase(), ocode);
                optioncodes.put(label.toLowerCase(), ocode);
            }
            this.cufOptionByLabelOrCode.put(cufcode.toLowerCase(), optioncodes);
        }
    }

    private void initBooleans() {
        this.booleanByAnymean.put("0", STR_FALSE);
        this.booleanByAnymean.put(STR_FALSE, STR_FALSE);
        this.booleanByAnymean.put(this.lang.getMessage("label.False", null, STR_FALSE, this.locale), STR_FALSE);
        this.booleanByAnymean.put(STR_NO, STR_FALSE);
        this.booleanByAnymean.put(this.lang.getMessage("label.No", null, STR_NO, this.locale), STR_FALSE);
        this.booleanByAnymean.put(STR_TRUE, STR_TRUE);
        this.booleanByAnymean.put(this.lang.getMessage("label.True", null, STR_TRUE, this.locale), STR_TRUE);
        this.booleanByAnymean.put(STR_YES, STR_TRUE);
        this.booleanByAnymean.put(this.lang.getMessage("label.Yes", null, STR_YES, this.locale), STR_TRUE);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SquashHelper initialized with following data :\n");
        builder.append("categories are :\n");
        for (Map.Entry<String, ListItemReference> entry : this.categoriesByLabelOrCode.entrySet()) {
            builder.append("\t" + entry.getKey() + " -> " + entry.getValue().getCode() + "\n");
        }
        builder.append("criticalities are :\n");
        for (Map.Entry<String, ListItemReference> entry : this.criticByLabelOrCode.entrySet()) {
            builder.append("\t" + entry.getKey() + " -> " + ((RequirementCriticality)entry.getValue()).toString() + "\n");
        }
        builder.append("statuses are :\n");
        for (Map.Entry<String, ListItemReference> entry : this.statusByLabelOrCode.entrySet()) {
            builder.append("\t" + entry.getKey() + " -> " + ((RequirementStatus)entry.getValue()).toString() + "\n");
        }
        builder.append("customfields are :\n");
        for (Map.Entry<String, ListItemReference> entry : this.customfieldTypesByCode.entrySet()) {
            String cufcode = entry.getKey();
            InputType type = (InputType)entry.getValue();
            builder.append("\t" + cufcode + " (" + type + ")\n");
            if (type == InputType.DROPDOWN_LIST) {
                String def = this.customFieldDefaultsByCode.get(cufcode);
                builder.append("\t\tdefault : " + def + ", detail : \n");
                for (Map.Entry<String, String> options : this.cufOptionByLabelOrCode.get(cufcode).entrySet()) {
                    builder.append("\t\t" + options.getKey() + " -> " + options.getValue() + "\n");
                }
                continue;
            }
            builder.append("\n");
        }
        builder.append("booleans are :\n");
        for (Map.Entry<String, Object> entry : this.booleanByAnymean.entrySet()) {
            String key = entry.getKey();
            String val = (String)entry.getValue();
            builder.append("\t" + key + " -> " + val + "\n");
        }
        builder.append("\t(any non-0 digit) -> true\n");
        return builder.toString();
    }
}

