/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RestServerOAuth2ConfigurationDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;

@Component
public class ServerOAuth2ConfigurationValidator
implements Validator {
    @Inject
    private HelpValidator helpValidator;

    public boolean supports(Class<?> clazz) {
        return RestServerOAuth2ConfigurationDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RestServerOAuth2ConfigurationDto serverOAuth2Configuration = (RestServerOAuth2ConfigurationDto)target;
        this.helpValidator.validateAttributes("grantType", errors);
        this.helpValidator.validateAttributes("clientId", errors);
        this.helpValidator.validateAttributes("clientSecret", errors);
        this.helpValidator.validateAttributes("authorizationUrl", errors);
        this.helpValidator.validateUrl(serverOAuth2Configuration.getAuthorizationUrl(), errors);
        this.helpValidator.validateAttributes("requestTokenUrl", errors);
        this.helpValidator.validateUrl(serverOAuth2Configuration.getRequestTokenUrl(), errors);
        this.helpValidator.validateAttributes("callbackUrl", errors);
        this.helpValidator.validateUrl(serverOAuth2Configuration.getCallbackUrl(), errors);
        this.helpValidator.validateAttributes("scope", errors);
    }
}

