/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ScmServerDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.internal.scmserver.ScmConnectorRegistry;

@Component
public class ScmServerValidator
implements Validator {
    @Inject
    private ScmServerDao scmServerDao;
    @Inject
    private HelpValidator helpValidator;
    @Inject
    private ScmConnectorRegistry scmConnectorRegistry;
    private static final String PATCH_SCM_SERVER = "patch-scm-server";
    private static final String POST_SCM_SERVER = "post-scm-server";

    public boolean supports(Class<?> aClass) {
        return ScmServerDto.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void scmServerPostValidator(ScmServerDto scmServerDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)scmServerDto, POST_SCM_SERVER);
        this.validate(scmServerDto, (Errors)validation);
        if (scmServerDto.getId() != null) {
            validation.rejectValue("id", "generated value", "This attribute is generated by database. ");
        }
        this.validateNameScmServer((Errors)validation, scmServerDto);
        this.validateUrlScmServer((Errors)validation, scmServerDto);
        this.validateKindScmServer((Errors)validation, scmServerDto);
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)scmServerDto, errors, (String)POST_SCM_SERVER);
    }

    public void scmServerPatchValidator(Long scmServerId, ScmServerDto scmServerDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)scmServerDto, PATCH_SCM_SERVER);
        this.validate(scmServerDto, (Errors)validation);
        if (this.scmServerDao.getReferenceById((Object)scmServerId) == null) {
            String message = String.format("No entity known for type scmServer and id %d", scmServerId);
            validation.rejectValue("id", "invalid id", message);
        }
        ScmServer scmServer = (ScmServer)this.scmServerDao.getReferenceById((Object)scmServerId);
        if (scmServerDto.isHasName() && !scmServer.getName().equals(scmServerDto.getName())) {
            this.validateNameScmServer((Errors)validation, scmServerDto);
        }
        if (scmServerDto.isHasUrl()) {
            this.validateUrlScmServer((Errors)validation, scmServerDto);
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)scmServerDto, errors, (String)PATCH_SCM_SERVER);
    }

    private void validateNameScmServer(Errors errors, ScmServerDto scmServerDto) {
        if (StringUtils.isBlank((CharSequence)scmServerDto.getName())) {
            this.helpValidator.validateAttributes("name", errors);
        } else if (this.scmServerDao.isServerNameAlreadyInUse(scmServerDto.getName())) {
            errors.rejectValue("name", "generated value", "The name is already used by another server. ");
        }
    }

    private void validateUrlScmServer(Errors errors, ScmServerDto scmServerDto) {
        if (StringUtils.isBlank((CharSequence)scmServerDto.getUrl())) {
            this.helpValidator.validateAttributes("url", errors);
        } else {
            this.helpValidator.validateUrl(scmServerDto.getUrl(), errors);
        }
    }

    private void validateKindScmServer(Errors errors, ScmServerDto scmServerDto) {
        if (StringUtils.isBlank((CharSequence)scmServerDto.getKind())) {
            this.helpValidator.validateAttributes("kind", errors);
        } else {
            Set registeredScmConnectorsMap = this.scmConnectorRegistry.getRegisteredScmKinds();
            boolean scmConnectorProvider = registeredScmConnectorsMap.contains(scmServerDto.getKind());
            if (!scmConnectorProvider) {
                errors.rejectValue("kind", "invalid value", "No registered ScmConnectorProvider is of type '" + scmServerDto.getKind() + "'.");
            }
        }
    }
}

