/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.domain.infolist.SystemInfoListItemCode;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;
import org.squashtest.tm.plugin.rest.admin.jackson.model.InfoListDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.InfoListItemDto;
import org.squashtest.tm.plugin.rest.admin.service.RestInfoListService;
import org.squashtest.tm.plugin.rest.repository.RestInfoListRepository;
import org.squashtest.tm.service.infolist.InfoListBindingManagerService;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.repository.InfoListDao;
import org.squashtest.tm.service.internal.repository.InfoListItemDao;

@Service
@Transactional
public class RestInfoListServiceImpl
implements RestInfoListService {
    @Inject
    private InfoListDao infoListDao;
    @Inject
    private InfoListManagerService infoListManagerService;
    @Inject
    private InfoListItemManagerService infoListItemManagerService;
    @Inject
    private InfoListItemDao infoListItemDao;
    @Inject
    private InfoListBindingManagerService ilbManagerService;
    @Inject
    private RestInfoListRepository restInfoListRepository;
    private static final String DEFAULT_ICON_NAME_LABEL = "noicon";

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoList createInfoList(InfoList infoList) {
        return this.infoListManagerService.persist(infoList);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoList updateInfolist(Long infolistId, InfoListDto infolistDto) {
        int i = 0;
        InfoList infolistToUpdate = (InfoList)this.infoListDao.getReferenceById((Object)infolistId);
        SystemInfoListCode.verifyModificationPermission((InfoList)infolistToUpdate);
        this.checkDuplicateCode(infolistToUpdate, infolistDto.getCode());
        if (infolistDto.getLabel() != null && !infolistDto.getLabel().equals(infolistToUpdate.getLabel())) {
            infolistToUpdate.setLabel(infolistDto.getLabel());
        }
        if (infolistDto.getCode() != null && !infolistDto.getCode().equals(infolistToUpdate.getCode())) {
            infolistToUpdate.setCode(infolistDto.getCode());
        }
        if (infolistDto.getDescription() != null && !infolistDto.getDescription().equals(infolistToUpdate.getDescription())) {
            infolistToUpdate.setDescription(infolistDto.getDescription());
        }
        for (InfoListItem infoListItem : infolistToUpdate.getItems()) {
            InfoListItem infolistItemToUpdate = (InfoListItem)this.infoListItemDao.getReferenceById((Object)infoListItem.getId());
            if (infolistDto.getItems().get(i).getLabel() != null && !infolistDto.getItems().get(i).getLabel().equals(infolistItemToUpdate.getLabel())) {
                infolistItemToUpdate.setLabel(infolistDto.getItems().get(i).getLabel());
            }
            if (infolistDto.getItems().get(i).getIconName() != null && !infolistDto.getItems().get(i).getIconName().equals(infolistItemToUpdate.getIconName())) {
                infolistItemToUpdate.setIconName(infolistDto.getItems().get(i).getIconName());
            }
            if (infolistItemToUpdate.isDefault() != infolistDto.getItems().get(i).isDefault()) {
                this.setDefaultInfolistItem(infolistItemToUpdate, infolistDto.getItems().get(i).isDefault(), true);
            }
            if (infolistDto.getItems().get(i).getColour() != null && !infolistDto.getItems().get(i).getColour().equals(infolistItemToUpdate.getColour())) {
                infolistItemToUpdate.setColour(infolistDto.getItems().get(i).getColour());
            }
            if (infolistDto.getItems().get(i).getCode() != null && !infolistDto.getItems().get(i).getCode().equals(infolistItemToUpdate.getCode())) {
                infolistItemToUpdate.setCode(infolistDto.getItems().get(i).getCode());
            }
            ++i;
            this.infoListItemDao.saveAndFlush((Object)infolistItemToUpdate);
        }
        return infolistToUpdate;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoListItem updateInfoListItem(Long infoListItemId, InfoListItemDto infoListItemDto) {
        InfoListItem infoListItemToUpdate = (InfoListItem)this.infoListItemDao.getReferenceById((Object)infoListItemId);
        SystemInfoListItemCode.verifyModificationPermission((InfoListItem)infoListItemToUpdate);
        if (infoListItemDto.getCode() != null && !infoListItemToUpdate.getCode().equals(infoListItemDto.getCode())) {
            this.checkDuplicateCode(infoListItemToUpdate, infoListItemDto.getCode());
            infoListItemToUpdate.setCode(infoListItemDto.getCode());
        }
        if (infoListItemDto.getLabel() != null && !infoListItemToUpdate.getLabel().equals(infoListItemDto.getLabel())) {
            infoListItemToUpdate.setLabel(infoListItemDto.getLabel());
        }
        if (infoListItemDto.getIconName() != null && !infoListItemToUpdate.getIconName().equals(infoListItemDto.getIconName())) {
            infoListItemToUpdate.setIconName(infoListItemDto.getIconName());
        }
        if (infoListItemDto.getColour() != null && !infoListItemToUpdate.getColour().equals(infoListItemDto.getColour())) {
            infoListItemToUpdate.setColour(infoListItemDto.getColour());
        }
        if (infoListItemToUpdate.isDefault() != infoListItemDto.isDefault()) {
            this.setDefaultInfolistItem(infoListItemToUpdate, infoListItemDto.isDefault(), false);
        }
        this.infoListItemDao.saveAndFlush((Object)infoListItemToUpdate);
        return infoListItemToUpdate;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteSeveralInfolist(List<Long> infolistItemIds) {
        this.infoListManagerService.remove(infolistItemIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoListItem addInfolistItem(Long infolistId, InfoListItem infoListItem) {
        InfoList infolistToUpdate = (InfoList)this.infoListDao.getReferenceById((Object)infolistId);
        SystemInfoListCode.verifyModificationPermission((InfoList)infolistToUpdate);
        infoListItem.setDefault(infolistToUpdate.getItems().isEmpty());
        if (infoListItem.getIconName().isEmpty()) {
            infoListItem.setIconName(DEFAULT_ICON_NAME_LABEL);
        }
        infoListItem.setInfoList(infolistToUpdate);
        this.infoListItemDao.save((Object)infoListItem);
        infolistToUpdate.addItem(infoListItem);
        return infoListItem;
    }

    private void setDefaultInfolistItem(InfoListItem infoListItemToUpdate, boolean isDefault, boolean isFromInfoList) {
        List items = infoListItemToUpdate.getInfoList().getItems();
        if (!infoListItemToUpdate.getInfoList().getDefaultItem().getId().equals(infoListItemToUpdate.getId())) {
            if (isDefault) {
                for (InfoListItem item : items) {
                    item.setDefault(false);
                }
                infoListItemToUpdate.setDefault(true);
            }
        } else if (!(isDefault || isFromInfoList && items.size() != 1)) {
            throw new IllegalArgumentException("Cannot update the default value of the default item.");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoListItem findItemById(Long infoListItemId) {
        return (InfoListItem)this.infoListItemDao.getReferenceById((Object)infoListItemId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteInfolistItem(Long infolistItemId) {
        InfoListItem itemToDelete = (InfoListItem)this.infoListItemDao.getReferenceById((Object)infolistItemId);
        InfoList infoList = itemToDelete.getInfoList();
        SystemInfoListCode.verifyModificationPermission((InfoList)infoList);
        this.infoListItemManagerService.removeInfoListItem(infolistItemId.longValue(), infoList.getId().longValue());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<InfoList> findAllUserLists(Pageable pageable) {
        return this.restInfoListRepository.findAllUserLists(pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoList findById(Long infoListId) {
        return (InfoList)this.infoListDao.getReferenceById((Object)infoListId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindListToProjectReqCategory(Long infoListId, Long projectId) {
        this.ilbManagerService.bindListToProjectReqCategory(infoListId.longValue(), projectId.longValue());
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindListToProjectTcNature(Long infoListId, Long projectId) {
        this.ilbManagerService.bindListToProjectTcNature(infoListId.longValue(), projectId.longValue());
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindListToProjectTcType(Long infoListId, Long projectId) {
        this.ilbManagerService.bindListToProjectTcType(infoListId.longValue(), projectId.longValue());
    }

    private void checkDuplicateCode(InfoList infoList, String newCode) {
        if (!StringUtils.equals((CharSequence)infoList.getCode(), (CharSequence)newCode) && this.infoListDao.findByCode(newCode) != null) {
            throw new CodeAlreadyExistsException(infoList.getCode(), newCode, InfoList.class);
        }
    }

    private void checkDuplicateCode(InfoListItem infoListItem, String newCode) {
        if (!StringUtils.equals((CharSequence)infoListItem.getCode(), (CharSequence)newCode) && this.infoListItemDao.findByCode(newCode) != null) {
            throw new CodeAlreadyExistsException(infoListItem.getCode(), newCode, InfoListItem.class);
        }
    }
}

