/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.rest.admin.jackson.model.TestAutomationServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAutomationServersService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.TestAutomationServerPatcher;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;

@Service
@Transactional
public class RestAutomationServersServiceImpl
implements RestAutomationServersService {
    @Inject
    private TestAutomationServerManagerService service;
    @Inject
    private TestAutomationServerPatcher serverPatcher;
    @Inject
    private TestAutomationServerDao serverDao;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public TestAutomationServer createNewAutomationServer(TestAutomationServer server) {
        this.service.persist(server);
        return this.serverDao.findByName(server.getName());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public TestAutomationServer updateAutomationServer(TestAutomationServer server, TestAutomationServerDto serverDto) {
        this.serverPatcher.patch(server, serverDto);
        if (serverDto.isHasManualSelection()) {
            this.service.changeManualSlaveSelection(server.getId().longValue(), serverDto.isManualSlaveSelection());
        }
        return server;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteAutomationServer(List<Long> serverIds) {
        this.service.deleteServers(serverIds);
    }
}

