/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.squashtest.tm.domain.scm.ScmServer;

public class ScmServerSerializer
extends StdSerializer<ScmServer> {
    public ScmServerSerializer() {
        super(ScmServer.class);
    }

    public void serialize(ScmServer value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.doSerialize(value, gen);
    }

    public void serializeWithType(ScmServer value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.doSerialize(value, gen);
    }

    private void doSerialize(ScmServer value, JsonGenerator gen) throws IOException {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("_type", "scm-server");
        attributes.put("id", value.getId());
        attributes.put("name", value.getName());
        attributes.put("url", value.getUrl());
        attributes.put("kind", value.getKind());
        attributes.put("committer_mail", value.getCommitterMail());
        attributes.put("_links", new HashMap<String, Object>(value){
            {
                this.put("self", new HashMap<String, String>(scmServer){
                    {
                        this.put("href", "http://localhost:8080/api/rest/latest/scm-servers/" + scmServer.getId());
                    }
                });
            }
        });
        gen.writeObject(attributes);
    }
}

