/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.internal.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.wizard.campaignassistant.internal.service.CampaignAssistantWizardService;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.AdvancedIterationReplicationCriteria;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.AdvancedIterationReplicationCriteriaDto;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationReplicationModel;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationTestPlanItemDto;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.SimpleIterationReplicationCriteria;

@Controller
@RequestMapping(value={"backend/plugin/campaign-assistant/iteration-replication"})
public class IterationReplicationController {
    @Inject
    private IterationModificationService iterationService;
    @Inject
    private CampaignAssistantWizardService wizardService;

    @RequestMapping(value={"/available-iterations"})
    @ResponseBody
    public List<NamedReference> getAvailableIterations(@RequestParam long entityId, @RequestParam String entityType) {
        Long campaignId = null;
        switch (entityType) {
            case "ITERATION": {
                campaignId = ((Iteration)this.iterationService.findById(entityId)).getCampaign().getId();
                break;
            }
            case "CAMPAIGN": {
                campaignId = entityId;
                break;
            }
            default: {
                throw new IllegalArgumentException("The entity must either be an Iteration or a Camapaign to fetch available Iterations. Found type was: " + entityType);
            }
        }
        return this.wizardService.getIterationsByCampaignId(campaignId);
    }

    @GetMapping(value={"/remote-issues"})
    @ResponseBody
    public Map<String, List<RemoteIssue>> getRemoteIssues(@RequestParam long iterationId, @RequestParam long serverId) {
        List<RemoteIssue> issues = this.wizardService.findIssues(iterationId, serverId);
        return Collections.singletonMap("remoteIssues", issues);
    }

    @GetMapping(value={"/remote-issues-last-exec"})
    @ResponseBody
    public Map<String, List<RemoteIssue>> getRemoteIssuesOnlyLastExec(@RequestParam long iterationId, @RequestParam long serverId) {
        List<RemoteIssue> issues = this.wizardService.findIssuesOnlyLastExec(iterationId, serverId);
        return Collections.singletonMap("remoteIssues", issues);
    }

    @RequestMapping(value={"/count-iterations"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer getNbIterations(@RequestParam long iterationId) {
        return this.wizardService.getNbIterations(iterationId);
    }

    @PostMapping(value={"/preview"})
    @ResponseBody
    public Map<String, List<IterationTestPlanItemDto>> getTestPlanPreviewModel(@RequestBody SimpleIterationReplicationCriteria criteria) {
        return Collections.singletonMap("testPlan", this.wizardService.getReplicatedITPI(criteria));
    }

    @PostMapping(value={"/advanced-preview"})
    @ResponseBody
    public Map<String, List<IterationTestPlanItemDto>> getTestPlanPreviewModel(@RequestBody AdvancedIterationReplicationCriteriaDto criteriaDto) {
        AdvancedIterationReplicationCriteria criteria = criteriaDto.toCriteria();
        if (criteria.isKeepIssued() && criteria.isJiraServer()) {
            List<RemoteIssue> issues = criteria.isIssuesAllExecs() ? this.wizardService.findIssues(criteria.getIterationId(), criteria.getServerId()) : this.wizardService.findIssuesOnlyLastExec(criteria.getIterationId(), criteria.getServerId());
            ArrayList<String> remoteIds = new ArrayList<String>();
            Map<String, List<String>> keepIssuedCriteriaMap = criteria.getKeepIssuedCriteria();
            if (keepIssuedCriteriaMap != null) {
                for (RemoteIssue issue : issues) {
                    boolean issueHasCriteria = this.issueHasCriteria(keepIssuedCriteriaMap, issue);
                    if (!issueHasCriteria) continue;
                    remoteIds.add(issue.getId());
                }
            }
            if (remoteIds.size() != 0) {
                criteria.setItpiKeepIssued(this.wizardService.findItpisByRemoteIssues(criteria.getIterationId(), remoteIds));
            }
        }
        return Collections.singletonMap("testPlan", this.wizardService.getReplicatedITPI(criteria));
    }

    private boolean issueHasCriteria(Map<String, List<String>> keepIssuedCriteriaMap, RemoteIssue issue) {
        boolean hasAssignee;
        boolean hasStatus = keepIssuedCriteriaMap.get("status") != null && issue.getStatus() != null && keepIssuedCriteriaMap.get("status").contains(issue.getStatus().getName());
        boolean hasPriority = keepIssuedCriteriaMap.get("priority") != null && issue.getPriority() != null && keepIssuedCriteriaMap.get("priority").contains(issue.getPriority().getName());
        boolean bl = hasAssignee = keepIssuedCriteriaMap.get("assignee") != null && issue.getAssignee() != null && keepIssuedCriteriaMap.get("assignee").contains(issue.getAssignee().getName());
        return hasStatus || hasPriority || hasAssignee;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Long> replicateIteration(@RequestBody IterationReplicationModel iterationModel) {
        return Collections.singletonMap("id", this.wizardService.replicateIteration(iterationModel));
    }
}

