/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.internal.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.library.GenericLibraryNode;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.internal.service.UserAccessService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import org.squashtest.tm.wizard.campaignassistant.internal.exception.MultipleSelectionException;
import org.squashtest.tm.wizard.campaignassistant.internal.exception.NoAvailableIterationException;
import org.squashtest.tm.wizard.campaignassistant.internal.exception.NoSelectionException;
import org.squashtest.tm.wizard.campaignassistant.internal.exception.PluginNotEnabledException;
import org.squashtest.tm.wizard.campaignassistant.internal.model.NamedReferenceList;
import org.squashtest.tm.wizard.campaignassistant.internal.model.WizardModel;
import org.squashtest.tm.wizard.campaignassistant.internal.service.CampaignAssistantWizardService;

@Controller
@RequestMapping(value={"backend/plugin/campaign-assistant"})
public class CampaignAssistantWizardController {
    private final InternationalizationHelper messageSource;
    private final GenericProjectFinder projectFinder;
    private final CustomGenericProjectManager projectManager;
    private final UserAccessService userAccessService;
    private final CampaignAssistantWizardService wizardService;
    private final BugTrackersLocalService bugTrackersLocalService;
    private final IterationModificationService iterationModificationService;
    private final CampaignModificationService campaignModificationService;
    private final CredentialsProvider credentialsProvider;

    public CampaignAssistantWizardController(InternationalizationHelper messageSource, GenericProjectFinder projectFinder, CustomGenericProjectManager projectManager, UserAccessService userAccessService, CampaignAssistantWizardService wizardService, BugTrackersLocalService bugTrackersLocalService, IterationModificationService iterationModificationService, CampaignModificationService campaignModificationService, CredentialsProvider credentialsProvider) {
        this.messageSource = messageSource;
        this.projectFinder = projectFinder;
        this.projectManager = projectManager;
        this.userAccessService = userAccessService;
        this.wizardService = wizardService;
        this.bugTrackersLocalService = bugTrackersLocalService;
        this.iterationModificationService = iterationModificationService;
        this.campaignModificationService = campaignModificationService;
        this.credentialsProvider = credentialsProvider;
    }

    @GetMapping
    @ResponseBody
    public WizardModel startWizard(@RequestParam(value="campaigns", required=false) List<Long> campaignsIds, @RequestParam(value="iterations", required=false) List<Long> iterationsIds, Locale locale) {
        WizardModel model = new WizardModel();
        EntityReference selectedNode = this.coerceSelectedNode(campaignsIds, iterationsIds);
        long projectId = this.getEntityRefProjectId(selectedNode);
        this.checkPluginActivationOnProject(projectId);
        List<NamedReference> availableIterations = this.getAvailableIterations(selectedNode);
        if (availableIterations.size() == 0) {
            throw new NoAvailableIterationException();
        }
        model.setAvailableIterations(availableIterations);
        model.setTestSuitesByIteration(this.getTestSuitesByIterations(availableIterations));
        model.setSelectedNodeId(selectedNode.getId());
        model.setSelectedNodeType(selectedNode.getType().name());
        model.setExecutionStatuses(this.getAvailableExecutionStatuses(projectId, locale));
        model.setExecutionModes(this.getAvailableExecutionModes(locale));
        model.setExecutionUsers(this.getAvailableExecutionUsers(projectId));
        model.setRequirementCriticalities(this.getRequirementCriticalities(locale));
        model.setRequirementStatuses(this.getRequirementStatuses(locale));
        model.setRequirementCategories(this.getRequirementCategories(locale, selectedNode));
        model.setTestCaseStatuses(this.getTestCaseStatuses(locale));
        model.setTestCaseImportances(this.getTestCaseImportances(locale));
        model.setTestCaseNatures(this.getTestCaseNatures(locale, selectedNode));
        model.setTestCaseTypes(this.getTestCaseTypes(locale, selectedNode));
        this.appendBugtrackerInfo(model, projectId);
        return model;
    }

    private Map<Long, List<NamedReference>> getTestSuitesByIterations(List<NamedReference> availableIterations) {
        return availableIterations.stream().collect(Collectors.toMap(NamedReference::getId, ref -> this.iterationModificationService.findAllTestSuitesAsNamedReferences(ref.getId().longValue())));
    }

    private void appendBugtrackerInfo(WizardModel model, long projectId) {
        BugTracker bt;
        Project currentProject = (Project)this.projectFinder.findById(projectId);
        if (currentProject.isBoundToBugtracker() && (bt = currentProject.getBugTracker()) != null) {
            model.setBugTracker(BugTrackerDto.from((BugTracker)bt));
            model.setServerStatus(this.checkAuthenticationStatus(bt));
        }
    }

    private AuthenticationStatus checkAuthenticationStatus(BugTracker bt) {
        boolean hasCreds = bt.getAuthenticationPolicy() == AuthenticationPolicy.USER ? this.credentialsProvider.hasCredentials((ThirdPartyServer)bt) : this.credentialsProvider.hasAppLevelCredentials((ThirdPartyServer)bt);
        return hasCreds ? AuthenticationStatus.AUTHENTICATED : AuthenticationStatus.NON_AUTHENTICATED;
    }

    private List<NamedReference> getAvailableExecutionUsers(long projectId) {
        return this.userAccessService.getUsersWhoCanAccessProjects(Collections.singletonList(projectId));
    }

    private EntityReference coerceSelectedNode(List<Long> campaignsIds, List<Long> iterationsIds) throws NoSelectionException, MultipleSelectionException {
        EntityReference ref = null;
        int totalSize = this.size(campaignsIds) + this.size(iterationsIds);
        if (totalSize == 0) {
            throw new NoSelectionException();
        }
        if (totalSize > 1) {
            throw new MultipleSelectionException(campaignsIds, iterationsIds);
        }
        if (CollectionUtils.isNotEmpty(campaignsIds)) {
            ref = new EntityReference(EntityType.CAMPAIGN, campaignsIds.get(0));
        }
        if (CollectionUtils.isNotEmpty(iterationsIds)) {
            ref = new EntityReference(EntityType.ITERATION, iterationsIds.get(0));
        }
        return ref;
    }

    private long getEntityRefProjectId(EntityReference entityRef) {
        return switch (entityRef.getType()) {
            case EntityType.CAMPAIGN_LIBRARY -> {
                CampaignLibrary library = (CampaignLibrary)this.wizardService.coerceIntoNode(entityRef);
                yield library.getProject().getId();
            }
            case EntityType.CAMPAIGN_FOLDER, EntityType.CAMPAIGN, EntityType.ITERATION -> {
                TreeNode node = (TreeNode)this.wizardService.coerceIntoNode(entityRef);
                yield node.getProject().getId();
            }
            default -> throw new IllegalArgumentException(entityRef.toString());
        };
    }

    private Set<Project> getTestCaseProjects(EntityReference ref) {
        switch (ref.getType()) {
            case ITERATION: {
                return ((Iteration)this.iterationModificationService.findById(ref.getId().longValue())).getTestPlans().stream().map(IterationTestPlanItem::getReferencedTestCase).filter(Objects::nonNull).map(GenericLibraryNode::getProject).collect(Collectors.toSet());
            }
            case CAMPAIGN: {
                return this.campaignModificationService.findById(ref.getId().longValue()).getIterations().stream().map(Iteration::getTestPlans).flatMap(Collection::stream).map(IterationTestPlanItem::getReferencedTestCase).filter(Objects::nonNull).map(GenericLibraryNode::getProject).collect(Collectors.toSet());
            }
        }
        throw new IllegalArgumentException("The entity must either be an Iteration or a Campaign to fetch available Iterations. Found type was: " + ref.getType());
    }

    private Set<Project> getRequirementProjects(EntityReference ref) {
        switch (ref.getType()) {
            case ITERATION: {
                return ((Iteration)this.iterationModificationService.findById(ref.getId().longValue())).getTestPlans().stream().map(IterationTestPlanItem::getReferencedTestCase).filter(Objects::nonNull).map(TestCase::getRequirementVersionCoverages).flatMap(Collection::stream).map(requirement -> requirement.getVerifiedRequirementVersion().getProject()).collect(Collectors.toSet());
            }
            case CAMPAIGN: {
                return this.campaignModificationService.findById(ref.getId().longValue()).getIterations().stream().map(Iteration::getTestPlans).flatMap(Collection::stream).map(IterationTestPlanItem::getReferencedTestCase).filter(Objects::nonNull).map(TestCase::getRequirementVersionCoverages).flatMap(Collection::stream).map(requirement -> requirement.getVerifiedRequirementVersion().getProject()).collect(Collectors.toSet());
            }
        }
        throw new IllegalArgumentException("The entity must either be an Iteration or a Campaign to fetch available Iterations. Found type was: " + ref.getType());
    }

    private int size(List<Long> collection) {
        return collection == null ? 0 : collection.size();
    }

    private List<NamedReference> getAvailableExecutionStatuses(long projectId, Locale locale) {
        Set statuses = this.projectManager.enabledExecutionStatuses(projectId);
        return statuses.stream().map(status -> new NamedReference(Long.valueOf(status.getLevel()), this.messageSource.getMessage(status.getI18nKey(), null, status.toString(), locale))).collect(Collectors.toList());
    }

    private List<NamedReference> getAvailableExecutionModes(Locale locale) {
        TestCaseExecutionMode[] modes = new TestCaseExecutionMode[]{TestCaseExecutionMode.AUTOMATED, TestCaseExecutionMode.MANUAL};
        return Arrays.stream(modes).map(mode -> new NamedReference(Long.valueOf(mode.getLevel()), this.messageSource.getMessage(mode.getI18nKey(), null, mode.toString(), locale))).collect(Collectors.toList());
    }

    private List<NamedReference> getTestCaseStatuses(Locale locale) {
        return Arrays.stream(TestCaseStatus.values()).map(mode -> new NamedReference(Long.valueOf(mode.getLevel()), this.messageSource.getMessage(mode.getI18nKey(), null, mode.toString(), locale))).collect(Collectors.toList());
    }

    private List<NamedReference> getTestCaseImportances(Locale locale) {
        return Arrays.stream(TestCaseImportance.values()).map(mode -> new NamedReference(Long.valueOf(mode.getLevel()), this.messageSource.getMessage(mode.getI18nKey(), null, mode.toString(), locale))).collect(Collectors.toList());
    }

    private List<NamedReferenceList> getTestCaseNatures(Locale locale, EntityReference ref) {
        Set<Project> projects = this.getTestCaseProjects(ref);
        ArrayList<NamedReferenceList> optionLists = new ArrayList<NamedReferenceList>();
        for (Project project : projects) {
            ArrayList testCaseNatures = new ArrayList();
            testCaseNatures.addAll(project.getTestCaseNatures().getItems());
            optionLists.add(new NamedReferenceList(project.getTestCaseNatures().getId().toString(), project.getTestCaseNatures().getLabel(), testCaseNatures.stream().map(nature -> new NamedReference(nature.getId(), this.messageSource.getMessage(nature.getLabel(), null, nature.getLabel(), locale))).collect(Collectors.toList())));
        }
        return optionLists;
    }

    private List<NamedReferenceList> getTestCaseTypes(Locale locale, EntityReference ref) {
        Set<Project> projects = this.getTestCaseProjects(ref);
        ArrayList<NamedReferenceList> optionLists = new ArrayList<NamedReferenceList>();
        for (Project project : projects) {
            ArrayList testCaseTypes = new ArrayList();
            testCaseTypes.addAll(project.getTestCaseTypes().getItems());
            optionLists.add(new NamedReferenceList(project.getTestCaseTypes().getId().toString(), project.getTestCaseTypes().getLabel(), testCaseTypes.stream().map(nature -> new NamedReference(nature.getId(), this.messageSource.getMessage(nature.getLabel(), null, nature.getLabel(), locale))).collect(Collectors.toList())));
        }
        return optionLists;
    }

    private List<NamedReference> getRequirementCriticalities(Locale locale) {
        return Arrays.stream(RequirementCriticality.values()).map(criticality -> new NamedReference(Long.valueOf(criticality.getLevel()), this.messageSource.getMessage(criticality.getI18nKey(), null, criticality.getCode(), locale))).collect(Collectors.toList());
    }

    private List<NamedReference> getRequirementStatuses(Locale locale) {
        return Arrays.stream(RequirementStatus.values()).map(criticality -> new NamedReference(Long.valueOf(criticality.getLevel()), this.messageSource.getMessage(criticality.getI18nKey(), null, criticality.toString(), locale))).collect(Collectors.toList());
    }

    private List<NamedReferenceList> getRequirementCategories(Locale locale, EntityReference ref) {
        Set<Project> projects = this.getRequirementProjects(ref);
        ArrayList<NamedReferenceList> optionLists = new ArrayList<NamedReferenceList>();
        for (Project project : projects) {
            ArrayList categoryList = new ArrayList();
            categoryList.addAll(project.getRequirementCategories().getItems());
            optionLists.add(new NamedReferenceList(project.getRequirementCategories().getId().toString(), project.getRequirementCategories().getLabel(), categoryList.stream().map(nature -> new NamedReference(nature.getId(), this.messageSource.getMessage(nature.getLabel(), null, nature.getLabel(), locale))).collect(Collectors.toList())));
        }
        return optionLists;
    }

    List<NamedReference> getAvailableIterations(EntityReference campaignOrIteration) {
        Long campaignId = null;
        switch (campaignOrIteration.getType()) {
            case ITERATION: {
                campaignId = ((Iteration)this.iterationModificationService.findById(campaignOrIteration.getId().longValue())).getCampaign().getId();
                break;
            }
            case CAMPAIGN: {
                campaignId = campaignOrIteration.getId();
                break;
            }
            default: {
                throw new IllegalArgumentException("The entity must either be an Iteration or a Campaign to fetch available Iterations. Found type was: " + campaignOrIteration.getType());
            }
        }
        return this.wizardService.getIterationsByCampaignId(campaignId);
    }

    void checkPluginActivationOnProject(long projectId) {
        if (!this.wizardService.isWizardEnabledOnProject(projectId)) {
            throw new PluginNotEnabledException(projectId);
        }
    }
}

