/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.config;

import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.squashtest.tm.api.widget.MenuItem;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.wizard.campaignassistant.CampaignAssistantWizard;
import org.squashtest.tm.wizard.campaignassistant.CampaignAssistantWizardMenuItem;
import org.squashtest.tm.wizard.campaignassistant.licensevalidator.LicenseValidator;
import org.squashtest.tm.wizard.campaignassistant.licensevalidator.service.ValidationService;
import org.squashtest.tm.wizard.campaignassistant.licensevalidator.service.impl.ValidationServiceImpl;

@Configuration
public class CampaignAssistantConfig {
    @Inject
    MessageSource messageSource;

    @Bean(name={"squash.tm.wizard.campaignassistant"})
    public CampaignAssistantWizard campaignAssistantWizard() {
        CampaignAssistantWizardMenuItem menuItem = new CampaignAssistantWizardMenuItem();
        menuItem.setLabelKey("campaignassistant.workspace.menu.item.label");
        menuItem.setTooltipKey("campaignassistant.workspace.menu.item.tooltip");
        menuItem.setUrl("plugin/campaign-assistant/wizard");
        menuItem.setMessageSource(this.messageSource);
        menuItem.afterPropertiesSet();
        CampaignAssistantWizard wizard = new CampaignAssistantWizard();
        wizard.setNameKey("campaignassistant.name");
        wizard.setTypeKey("campaignassistant.type");
        wizard.setDisplayWorkspace(WorkspaceType.CAMPAIGN_WORKSPACE);
        wizard.setWizardMenu((MenuItem)menuItem);
        return wizard;
    }

    @Bean(name={"org.squashtest.tm.wizard.campaignassistant.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.wizard.campaignassistant.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.wizard.campaignassistant.ValidationService") @Named(value="org.squashtest.tm.wizard.campaignassistant.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

