/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.extension;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.Issue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssueReportForm;
import org.squashtest.tm.bugtracker.advanceddomain.ChangeSet;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.ScopedLabelHelper;
import org.squashtest.tm.plugin.bugtracker.gitlab.conversion.RemoteIssueContextFormatter;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.DeepSchemeBuilder;

public final class DelegateCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegateCommands.class);
    private static final String SET_LABELS_COMMAND = "setlabels:";
    public static final String SET_DESCRIPTION_TEMPLATE_COMMAND = "set-description-template";
    public static final String SET_ISSUE_TITLE_COMMAND = "set-issue-title";
    public static final int MIN_LENGTH_FOR_TEXT_SEARCH = 4;

    public static boolean isSetLabelsCommand(DelegateCommand command) {
        return command.getCommand().startsWith(SET_LABELS_COMMAND);
    }

    public static DelegateCommand buildSetLabelsCommand(String projectPath) {
        return new DelegateCommand(SET_LABELS_COMMAND + projectPath, (Object)"");
    }

    public static boolean isSetDescriptionTemplateCommand(DelegateCommand command) {
        return SET_DESCRIPTION_TEMPLATE_COMMAND.equals(command.getCommand());
    }

    public static boolean isSetIssueTitleCommand(DelegateCommand command) {
        return SET_ISSUE_TITLE_COMMAND.equals(command.getCommand());
    }

    public static ChangeSet executeSetLabelsCommand(DelegateCommand delegateCommand) {
        List items = (List)delegateCommand.getArgument();
        List<String> filtered = DelegateCommands.keepLastScopedLabels(items);
        FieldValue fieldValue = new FieldValue();
        fieldValue.setComposite((FieldValue[])filtered.stream().map(item -> new FieldValue(item, item)).toArray(FieldValue[]::new));
        return ChangeSet.forNewValue((String)"labels", (FieldValue)fieldValue);
    }

    private static List<String> keepLastScopedLabels(List<String> items) {
        ArrayList<String> copy = new ArrayList<String>(items);
        HashMap labelsByScope = new HashMap();
        copy.forEach(item -> {
            String scope = ScopedLabelHelper.extractLabelScope(item);
            if (scope != null) {
                if (!labelsByScope.containsKey(scope)) {
                    labelsByScope.put(scope, new ArrayList());
                }
                ((List)labelsByScope.get(scope)).add(item);
            }
        });
        Stream labelsToRemove = labelsByScope.values().stream().flatMap(scopedLabels -> {
            if (scopedLabels.size() > 1) {
                return scopedLabels.subList(0, scopedLabels.size() - 1).stream();
            }
            return Stream.empty();
        });
        labelsToRemove.forEach(copy::remove);
        return copy;
    }

    public static ChangeSet executeSetDescriptionTemplateCommand(DelegateCommand delegateCommand, GitLabApiWrapper gitLabApi, RemoteIssueContextFormatter formatter) throws GitLabApiException {
        String templateFile = (String)delegateCommand.getArgument();
        if (templateFile == null || StringUtils.isBlank((CharSequence)templateFile)) {
            return ChangeSet.forNewValue((String)"description", (FieldValue)new FieldValue(null, ""));
        }
        if (templateFile.equals(DeepSchemeBuilder.SQUASH_DESCRIPTION_TEMPLATE_ID)) {
            AdvancedIssueReportForm reportForm = delegateCommand.getContext().getReportForm();
            if (reportForm == null || reportForm.getRemoteIssueContext() == null) {
                LOGGER.debug("Cannot build Squash default description as the issue declaration context was not provided.");
                return null;
            }
            String squashDescription = formatter.buildDefaultDescription(reportForm.getRemoteIssueContext());
            return ChangeSet.forNewValue((String)"description", (FieldValue)new FieldValue(null, squashDescription));
        }
        String newContent = gitLabApi.getDescriptionTemplateContent(delegateCommand.getContext().getRemoteProject(), templateFile);
        return ChangeSet.forNewValue((String)"description", (FieldValue)new FieldValue(null, newContent));
    }

    public static ChangeSet executeSetIssueTitleCommand(DelegateCommand delegateCommand, GitLabApiWrapper gitLabApiWrapper, List<Long> remoteKnownIssueIds, int maxResultsPerSearch) throws GitLabApiException {
        if (delegateCommand.getArgument().toString().length() < 4) {
            return null;
        }
        List<Issue> issues = gitLabApiWrapper.getIssuesWithTitle(delegateCommand.getContext().getRemoteIssueCurrentFormRequest().get("projectPath").toString(), delegateCommand.getContext().getRemoteIssueCurrentFormRequest().get("issueTitle").toString(), Boolean.parseBoolean(delegateCommand.getContext().getRemoteIssueCurrentFormRequest().get("issueTitleCheckClosedIssues").toString()), maxResultsPerSearch);
        List<Issue> filteredIssues = issues.stream().filter(gitlabIssue -> !remoteKnownIssueIds.contains(gitlabIssue.getId())).toList();
        return ChangeSet.forNewPossibleValues((String)"issueTitle", (FieldValue[])((FieldValue[])filteredIssues.stream().map(issue -> new FieldValue(issue.getIid().toString(), issue.getTitle(), "#" + issue.getIid() + " - " + issue.getTitle())).toArray(FieldValue[]::new)));
    }
}

