/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.domain;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.AbstractUser;
import gitlabbt.org.gitlab4j.api.models.Epic;
import gitlabbt.org.gitlab4j.api.models.Label;
import gitlabbt.org.gitlab4j.api.models.Milestone;
import gitlabbt.org.gitlab4j.api.models.Project;
import gitlabbt.org.gitlab4j.api.models.ProjectUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.CommonConfigurationKey;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.CachedValues;
import org.squashtest.tm.plugin.bugtracker.gitlab.caching.ValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.ShallowSchemeBuilder;
import org.squashtest.tm.plugin.bugtracker.gitlab.extension.DelegateCommands;

@Component(value="squash.tm.plugin.bugtracker.gitlab.DeepSchemeBuilder")
public class DeepSchemeBuilder
extends ShallowSchemeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeepSchemeBuilder.class);
    public static String SQUASH_DESCRIPTION_TEMPLATE_ID = "_squash_";
    private final ValueCacheManager valueCacheManager;
    private Optional<CachedValues> cachedValues;

    public DeepSchemeBuilder(@Named(value="gitlabConnectorMessageSource") MessageSource messageSource, ValueCacheManager valueCacheManager) {
        super(messageSource);
        this.valueCacheManager = valueCacheManager;
    }

    @Override
    public Map<String, List<Field>> buildSchemes(Project project, GitLabApiWrapper gitLabApi) {
        this.cachedValues = this.valueCacheManager.isCacheEnabled(gitLabApi.getBugTracker().getId()) ? this.valueCacheManager.findCachedValues(gitLabApi.getBugTracker(), project.getPathWithNamespace()) : Optional.empty();
        return super.buildSchemes(project, gitLabApi);
    }

    @Override
    protected Field buildLabelsField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        Field field = this.buildBasicField("labels", InputType.TypeName.TAG_LIST.value);
        List<Label> labels = this.findLabels(project, gitLabApi);
        field.setPossibleValues((FieldValue[])labels.stream().map(label -> new FieldValue(label.getName(), label.getName())).toArray(FieldValue[]::new));
        if (GitLabApiWrapper.isPremiumProjectOrHigher(project)) {
            DelegateCommand command = DelegateCommands.buildSetLabelsCommand(project.getPath());
            field.getRendering().getInputType().addConfiguration(CommonConfigurationKey.ONCHANGE.value, command.getCommand());
        }
        return field;
    }

    private List<Label> findLabels(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        if (this.cachedValues.isPresent()) {
            return this.cachedValues.get().labels();
        }
        return gitLabApi.getProjectLabels(project);
    }

    @Override
    protected Field buildAssigneesField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        boolean hasMultiSelect = GitLabApiWrapper.isPremiumProjectOrHigher(project);
        String inputType = hasMultiSelect ? InputType.TypeName.MULTI_SELECT.value : InputType.TypeName.DROPDOWN_LIST.value;
        Field field = this.buildBasicField("assignees", inputType);
        List fieldValues = this.findProjectUsers(project, gitLabApi).stream().map(user -> new FieldValue(user.getId().toString(), DeepSchemeBuilder.formatUserName(user))).collect(Collectors.toCollection(ArrayList::new));
        if (!hasMultiSelect) {
            fieldValues.add(0, this.createEmptyFieldValue());
        }
        field.setPossibleValues(fieldValues.toArray(new FieldValue[0]));
        return field;
    }

    public static String formatUserName(AbstractUser<?> user) {
        return "%s (@%s)".formatted(user.getName(), user.getUsername());
    }

    private List<ProjectUser> findProjectUsers(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        if (this.cachedValues.isPresent()) {
            return this.cachedValues.get().assignableUsers();
        }
        return gitLabApi.getProjectUsers(project.getId());
    }

    private FieldValue createEmptyFieldValue() {
        return this.createEmptyFieldValue("interface.label.none");
    }

    private FieldValue createEmptyFieldValue(String i18nKey) {
        FieldValue fieldValue = new FieldValue("", "");
        String label = this.messageSource.getMessage(i18nKey, null, LocaleContextHolder.getLocale());
        fieldValue.setScalar(label);
        return fieldValue;
    }

    @Override
    protected Field buildMilestoneField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        Field field = this.buildBasicField("milestone", InputType.TypeName.DROPDOWN_LIST.value);
        List<Milestone> possibleMilestones = this.findMilestones(project, gitLabApi);
        List fieldValues = possibleMilestones.stream().map(milestone -> new FieldValue(milestone.getId().toString(), milestone.getTitle())).collect(Collectors.toCollection(ArrayList::new));
        fieldValues.add(0, this.createEmptyFieldValue());
        field.setPossibleValues(fieldValues.toArray(new FieldValue[0]));
        return field;
    }

    private List<Milestone> findMilestones(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        if (this.cachedValues.isPresent()) {
            return this.cachedValues.get().milestones();
        }
        return gitLabApi.getProjectMilestones(project);
    }

    @Override
    protected Field buildConfidentialField() {
        Field field = this.buildBasicField("confidential", InputType.TypeName.CHECKBOX.value);
        String i18nKey = "interface.report.confidential.help-message";
        String helpMessage = this.messageSource.getMessage(i18nKey, null, LocaleContextHolder.getLocale());
        field.getRendering().getInputType().addConfiguration(CommonConfigurationKey.HELP_MESSAGE.value, helpMessage);
        return field;
    }

    @Override
    protected Field buildLinkedIssueFieldIfSupported(Project project) {
        return null;
    }

    @Override
    protected Field buildEpicField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        try {
            Field field = this.buildBasicField("epic", InputType.TypeName.DROPDOWN_LIST.value);
            List<FieldValue> fieldValues = this.findEpics(project, gitLabApi).stream().map(epic -> new FieldValue(epic.getId().toString(), epic.getTitle())).collect(Collectors.toList());
            fieldValues.add(0, this.createEmptyFieldValue());
            field.setPossibleValues(fieldValues.toArray(new FieldValue[0]));
            field.getRendering().getInputType().addConfiguration(CommonConfigurationKey.FILTER_POSSIBLE_VALUES.value, "");
            return field;
        }
        catch (GitLabApiException ex) {
            if (ex.getHttpStatus() == 403 || ex.getHttpStatus() == 404) {
                LOGGER.info("Could not fetch description templates.", (Throwable)ex);
                return null;
            }
            throw ex;
        }
    }

    private List<Epic> findEpics(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        if (this.cachedValues.isPresent()) {
            return this.cachedValues.get().epics();
        }
        return gitLabApi.getEpics(project);
    }

    @Override
    protected Field buildLinkedIssuesField(Project project) {
        Field field = this.buildBasicField("linkedIssues", InputType.TypeName.FREE_TAG_LIST.value, "linked-issues");
        if (GitLabApiWrapper.isPremiumProjectOrHigher(project)) {
            String i18nKey = "interface.report.linked-issues.help-message";
            String helpMessage = this.messageSource.getMessage(i18nKey, null, LocaleContextHolder.getLocale());
            field.getRendering().getInputType().addConfiguration(CommonConfigurationKey.HELP_MESSAGE.value, helpMessage);
        }
        return field;
    }

    @Override
    protected Field buildDescriptionTemplateField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        String localeKeyPart = "description-template";
        Field field = this.buildBasicField("descriptionTemplate", InputType.TypeName.DROPDOWN_LIST.value, "description-template");
        List<FieldValue> possibleTemplates = gitLabApi.getDescriptionTemplates(project).stream().map(template -> new FieldValue(template, template)).collect(Collectors.toList());
        possibleTemplates.add(0, this.buildDefaultDescriptionTemplateValue());
        possibleTemplates.add(this.createEmptyFieldValue("interface.report.description-template.no-template"));
        field.setPossibleValues(possibleTemplates.toArray(new FieldValue[0]));
        InputType inputType = field.getRendering().getInputType();
        inputType.addConfiguration(CommonConfigurationKey.ONCHANGE.value, "set-description-template");
        String i18nKey = String.format("interface.report.%s.confirm-message", "description-template");
        String confirmMessage = this.messageSource.getMessage(i18nKey, null, LocaleContextHolder.getLocale());
        inputType.addConfiguration(CommonConfigurationKey.CONFIRM_MESSAGE.value, confirmMessage);
        return field;
    }

    public FieldValue buildDefaultDescriptionTemplateValue() {
        String i18nKey = "interface.label.default";
        String label = this.messageSource.getMessage(i18nKey, null, LocaleContextHolder.getLocale());
        return new FieldValue(SQUASH_DESCRIPTION_TEMPLATE_ID, label);
    }
}

