/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.Form;
import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.Constants;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Deployment;
import gitlabbt.org.gitlab4j.api.models.DeploymentFilter;
import gitlabbt.org.gitlab4j.api.models.MergeRequest;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class DeploymentsApi
extends AbstractApi {
    public DeploymentsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Deployment> getProjectDeployments(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, null, this.getDefaultPerPage()).all();
    }

    public Pager<Deployment> getProjectDeployments(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, null, itemsPerPage);
    }

    public Pager<Deployment> getProjectDeployments(Object projectIdOrPath, DeploymentFilter filter) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, filter, this.getDefaultPerPage());
    }

    public Pager<Deployment> getProjectDeployments(Object projectIdOrPath, DeploymentFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter != null ? filter.getQueryParams() : new GitLabApiForm();
        return new Pager<Deployment>(this, Deployment.class, itemsPerPage, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments");
    }

    public Stream<Deployment> getProjectDeploymentsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, null, this.getDefaultPerPage()).stream();
    }

    public Stream<Deployment> getProjectDeploymentsStream(Object projectIdOrPath, DeploymentFilter filter) throws GitLabApiException {
        return this.getProjectDeployments(projectIdOrPath, filter, this.getDefaultPerPage()).stream();
    }

    public Deployment getDeployment(Object projectIdOrPath, Integer deploymentId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments", deploymentId);
        return response.readEntity(Deployment.class);
    }

    public Optional<Deployment> getOptionalDeployment(Object projectIdOrPath, Integer deploymentId) {
        try {
            return Optional.ofNullable(this.getDeployment(projectIdOrPath, deploymentId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Deployment addDeployment(Object projectIdOrPath, String environment, String sha, String ref, Boolean tag, Constants.DeploymentStatus status) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("environment", environment, true).withParam("sha", sha, true).withParam("ref", ref, true).withParam("tag", tag, true).withParam("status", (Object)status, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments");
        return response.readEntity(Deployment.class);
    }

    public Deployment updateDeployment(Object projectIdOrPath, Integer deploymentId, Constants.DeploymentStatus status) throws GitLabApiException {
        if (deploymentId == null) {
            throw new RuntimeException("deploymentId cannot be null");
        }
        Deployment deployment = new Deployment();
        deployment.setStatus(status);
        Response response = this.put(Response.Status.OK, deployment, "projects", this.getProjectIdOrPath(projectIdOrPath), "deployments", deploymentId);
        return response.readEntity(Deployment.class);
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, Integer deploymentId) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, deploymentId, this.getDefaultPerPage()).all();
    }

    public Pager<MergeRequest> getMergeRequests(Object projectIdOrPath, Integer deploymentId, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "commits", deploymentId, "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(Object projectIdOrPath, Integer deploymentId) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, deploymentId, this.getDefaultPerPage()).stream();
    }
}

