/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.GenericType;
import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.models.AwardEmoji;
import java.util.List;

public class AwardEmojiApi
extends AbstractApi {
    public AwardEmojiApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<AwardEmoji> getIssueAwardEmojis(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji");
        return response.readEntity(new GenericType<List<AwardEmoji>>(){});
    }

    public List<AwardEmoji> getMergeRequestAwardEmojis(Object projectIdOrPath, Integer mergeRequestIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji");
        return response.readEntity(new GenericType<List<AwardEmoji>>(){});
    }

    public List<AwardEmoji> getSnippetAwardEmojis(Object projectIdOrPath, Integer snippetId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji");
        return response.readEntity(new GenericType<List<AwardEmoji>>(){});
    }

    public List<AwardEmoji> getNoteAwardEmojis(Object projectIdOrPath, Integer issueIid, Integer noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji");
        return response.readEntity(new GenericType<List<AwardEmoji>>(){});
    }

    public AwardEmoji getIssueAwardEmoji(Object projectIdOrPath, Integer issueIid, Integer awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji", awardId);
        return response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji getMergeRequestAwardEmoji(Object projectIdOrPath, Integer mergeRequestIid, Integer awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji", awardId);
        return response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji getSnippetAwardEmoji(Object projectIdOrPath, Integer snippetId, Integer awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji", awardId);
        return response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji getNoteAwardEmoji(Object projectIdOrPath, Integer issueIid, Integer noteId, Integer awardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(1, this.getDefaultPerPage()), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji", awardId);
        return response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addIssueAwardEmoji(Object projectIdOrPath, Integer issueIid, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji");
        return response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addMergeRequestAwardEmoji(Object projectIdOrPath, Integer mergeRequestIid, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji");
        return response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addSnippetAwardEmoji(Object projectIdOrPath, Integer snippetId, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji");
        return response.readEntity(AwardEmoji.class);
    }

    public AwardEmoji addNoteAwardEmoji(Object projectIdOrPath, Integer issueIid, Integer noteId, String name) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji");
        return response.readEntity(AwardEmoji.class);
    }

    public void deleteIssueAwardEmoji(Object projectIdOrPath, Integer issueIid, Integer awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "award_emoji", awardId);
    }

    public void deleteMergeRequestAwardEmoji(Object projectIdOrPath, Integer mergeRequestIid, Integer awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "award_emoji", awardId);
    }

    public void deleteSnippetAwardEmoji(Object projectIdOrPath, Integer snippetId, Integer awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "snippets", snippetId, "award_emoji", awardId);
    }

    public void deleteNoteAwardEmoji(Object projectIdOrPath, Integer issueIid, Integer noteId, Integer awardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId, "award_emoji", awardId);
    }
}

