/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldLink;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RequirementLinkTypeMappingDto;
import org.squashtest.tm.plugin.rest.admin.service.RestRequirementLinkTypeMappingService;

@Service
@Transactional
public class RestRequirementLinkTypeMappingServiceImpl
implements RestRequirementLinkTypeMappingService {
    @Inject
    private PluginRequirementDao configurationDao;

    @Override
    public RequirementLinkTypeMappingDto getRequirementLinkTypeMappingByIdForProject(Long projectId, Long requirementLinkTypeId) {
        Configuration configuration = this.configurationDao.getConfigurationForProject(projectId);
        FieldLink link = configuration.getFieldLinkByRequirementLinkTypeId(requirementLinkTypeId);
        return new RequirementLinkTypeMappingDto(link.getSquashLinkTypeId(), link.getSquashField(), link.getJiraField());
    }

    @Override
    public List<RequirementLinkTypeMappingDto> getAllRequirementLinkTypeMappingsForProject(Long projectId) {
        Configuration configuration = this.configurationDao.getConfigurationForProject(projectId);
        return configuration.getFieldLinks().stream().map(link -> new RequirementLinkTypeMappingDto(link.getSquashLinkTypeId(), link.getSquashField(), link.getJiraField())).collect(Collectors.toList());
    }

    @Override
    public RequirementLinkTypeMappingDto updateRequirementLinkTypeMapping(Long projectId, Long requirementLinkTypeId, RequirementLinkTypeMappingDto requirementLinkTypeMappingDto) {
        Configuration configuration = this.configurationDao.getConfigurationForProject(projectId);
        FieldLink fieldLink = configuration.getFieldLinkByRequirementLinkTypeId(requirementLinkTypeId);
        fieldLink.setJiraField(requirementLinkTypeMappingDto.getJiraField());
        this.configurationDao.storeConfigurationForProject(projectId, configuration);
        return new RequirementLinkTypeMappingDto(fieldLink.getSquashLinkTypeId(), fieldLink.getSquashField(), fieldLink.getJiraField());
    }
}

