/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.domain;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;

public class FieldMapping {
    private String squashField;
    private String jiraField;
    private boolean deletable;
    private boolean editable;

    public FieldMapping() {
    }

    public FieldMapping(BuiltinSquashField squashField, String jiraField) {
        this.squashField = squashField.toString();
        this.jiraField = jiraField;
    }

    public FieldMapping(String squashFieldId, String jiraFieldId) {
        this.squashField = squashFieldId;
        this.jiraField = jiraFieldId;
    }

    public String getId() {
        return this.squashField;
    }

    public String getSquashField() {
        return this.squashField;
    }

    public void setSquashField(String squashField) {
        this.squashField = StringUtils.trim((String)squashField);
    }

    public String getJiraField() {
        return this.jiraField;
    }

    public void setJiraField(String jiraField) {
        this.jiraField = StringUtils.trim((String)jiraField);
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public static List<FieldMapping> getBuiltinMapping() {
        return Arrays.asList(new FieldMapping(BuiltinSquashField.REFERENCE, "issuekey"), new FieldMapping(BuiltinSquashField.LABEL, "summary"), new FieldMapping(BuiltinSquashField.DESCRIPTION, "description"), new FieldMapping(BuiltinSquashField.CRITICALITY, "priority"));
    }

    public static FieldMapping byId(String id) {
        return new FieldMapping(id, null);
    }

    public String toString() {
        return this.squashField + "<->" + this.jiraField;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.squashField == null ? 0 : this.squashField.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldMapping other = (FieldMapping)obj;
        return !(this.squashField == null ? other.squashField != null : !this.squashField.equals(other.squashField));
    }
}

