/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.client.exception;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsDetailedException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.exception.MantisError;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.exception.MantisException;

@Component(value="mantisExceptionHandler")
public class ExceptionHandler
extends Exception {
    private final transient MessageSource messageSource;

    public ExceptionHandler(@Named(value="mantisConnectorMessageSource") @Named(value="mantisConnectorMessageSource") MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public BugTrackerRemoteException mantisHttpError(HttpClientErrorException ex) {
        String jsonBody = ex.getResponseBodyAsString();
        try {
            MantisError error = (MantisError)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(jsonBody, MantisError.class);
            return new MantisException(error);
        }
        catch (IOException e) {
            e.printStackTrace();
            return this.genericError((Exception)((Object)ex));
        }
    }

    public BugTrackerRemoteException genericError(Exception ex) {
        String translation = this.messageSource.getMessage("interface.exception.unknown-exception", null, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(String.format("%s %s", translation, ex.getMessage()), ex.getCause());
    }

    public BugTrackerNoCredentialsDetailedException connexionDenied() {
        String translation = this.messageSource.getMessage("interface.exception.access-denied", null, LocaleContextHolder.getLocale());
        return new BugTrackerNoCredentialsDetailedException(translation, null);
    }

    public BugTrackerRemoteException projectNotFound(String projectName) {
        String translation = this.messageSource.getMessage("interface.exception.not-found.project", new Object[]{projectName}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException issueNotFound(String workItemId) {
        String translation = this.messageSource.getMessage("interface.exception.not-found.issue", new Object[]{workItemId}, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException issueNotFound() {
        String translation = this.messageSource.getMessage("interface.exception.not-found.issue", null, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }

    public BugTrackerRemoteException cantUploadFiles() {
        String translation = this.messageSource.getMessage("interface.exception.cant-upload-file", null, LocaleContextHolder.getLocale());
        return new BugTrackerRemoteException(translation, null);
    }
}

