/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.scheduling;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.GitLabNoteBatchOrchestrator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;

@Component
public class GitLabReportingScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabReportingScheduler.class);
    private static final Duration NEW_ATTEMPT_DELAY = Duration.ofSeconds(60L);
    private final GitLabNoteBatchOrchestrator orchestrator;
    private final TaskScheduler taskScheduler;
    private final ConcurrentMap<GitLabClient, Set<NoteProcessInfo>> collectedInfos;
    private final ConcurrentMap<GitLabClient, Set<NoteProcessInfo>> processedInfos;
    private volatile boolean running = false;

    public GitLabReportingScheduler(GitLabNoteBatchOrchestrator orchestrator, @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler") @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler") TaskScheduler taskScheduler) {
        this.orchestrator = orchestrator;
        this.taskScheduler = taskScheduler;
        this.collectedInfos = new ConcurrentHashMap<GitLabClient, Set<NoteProcessInfo>>();
        this.processedInfos = new ConcurrentHashMap<GitLabClient, Set<NoteProcessInfo>>();
    }

    public synchronized void collectNoteProcessInfos(Map<GitLabClient, Set<NoteProcessInfo>> noteProcessInfosByClient) {
        noteProcessInfosByClient.forEach((gitLabClient, infosToCollect) -> {
            Set infoForThisClient = this.collectedInfos.getOrDefault(gitLabClient, new HashSet());
            infosToCollect.forEach(infoToCollect -> {
                Optional<NoteProcessInfo> infoToBeReplaced = infoForThisClient.stream().filter(collectedInfo -> noteProcessInfo.issueGlobalId.equals(collectedInfo.issueGlobalId)).findAny();
                infoToBeReplaced.ifPresent(infoForThisClient::remove);
                infoForThisClient.add(infoToCollect);
            });
            this.collectedInfos.put((GitLabClient)gitLabClient, infoForThisClient);
        });
        this.processedInfos.forEach((client, processInfos) -> {
            if (this.collectedInfos.containsKey(client)) {
                ((Set)this.collectedInfos.get(client)).removeAll((Collection<?>)processInfos);
            }
        });
        this.processedInfos.clear();
        if (!this.running) {
            this.startProcess();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private void startProcess() {
        this.doProcess();
    }

    private synchronized void doProcess() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Start GitLab note processing.");
        }
        this.running = true;
        try {
            this.processInfos();
            if (this.hasInfosToProcess()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("There are still notes to process. A new attempt will be made in %d seconds.", NEW_ATTEMPT_DELAY.getSeconds()));
                }
                this.taskScheduler.schedule(this::doProcess, Instant.now().plus(NEW_ATTEMPT_DELAY));
            } else {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Finished processing GitLab notes.");
                }
                this.running = false;
            }
        }
        catch (Exception ex) {
            this.running = false;
            throw ex;
        }
    }

    private void processInfos() {
        HashMap<GitLabClient, Set<NoteProcessInfo>> collectedInfosCopy = new HashMap<GitLabClient, Set<NoteProcessInfo>>(this.collectedInfos);
        HashMap<GitLabClient, Set<NoteProcessInfo>> processedInfosCopy = new HashMap<GitLabClient, Set<NoteProcessInfo>>(this.processedInfos);
        collectedInfosCopy.forEach((gitLabClient, noteProcessInfos) -> {
            Set alreadyProcessed = processedInfosCopy.getOrDefault(gitLabClient, new HashSet());
            Set toProcess = noteProcessInfos.stream().filter(npi -> !alreadyProcessed.contains(npi)).collect(Collectors.toSet());
            LOGGER.trace(String.format("Processing batch of %d notes for client %s.", toProcess.size(), gitLabClient));
            GitLabNoteBatchOrchestrator.BatchProcessResult batchProcessResult = this.orchestrator.processNotes((GitLabClient)gitLabClient, (List<NoteProcessInfo>)new ArrayList<NoteProcessInfo>(toProcess));
            Set processedWithSuccess = noteProcessInfos.stream().filter(info -> !this.hasError((NoteProcessInfo)info, batchProcessResult)).collect(Collectors.toSet());
            LOGGER.trace(String.format("Processed %d notes with success for client %s.", processedWithSuccess.size(), gitLabClient));
            if (!processedInfosCopy.containsKey(gitLabClient)) {
                processedInfosCopy.put((GitLabClient)gitLabClient, new HashSet());
            }
            ((Set)processedInfosCopy.get(gitLabClient)).addAll(processedWithSuccess);
        });
        processedInfosCopy.forEach((client, infos) -> {
            Set infosForThisClient = this.processedInfos.getOrDefault(client, new HashSet());
            infosForThisClient.addAll(infos);
            this.processedInfos.put((GitLabClient)client, infosForThisClient);
        });
    }

    private boolean hasInfosToProcess() {
        for (Map.Entry entry : this.collectedInfos.entrySet()) {
            GitLabClient client = (GitLabClient)entry.getKey();
            Set collectedInfosForClient = (Set)entry.getValue();
            if (!this.processedInfos.containsKey(client)) {
                return true;
            }
            if (((Set)this.processedInfos.get(client)).size() >= collectedInfosForClient.size()) continue;
            return true;
        }
        return false;
    }

    private boolean hasError(NoteProcessInfo info, GitLabNoteBatchOrchestrator.BatchProcessResult batchProcessResult) {
        return batchProcessResult.batchCreationResult.getErrorsByIssueId().containsKey(info.issueGlobalId) || batchProcessResult.batchUpdateResult.getErrorsByIssueId().containsKey(info.issueGlobalId);
    }
}

