/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.debug.DebugTimer;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.UpdateIssueNoteMutation;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.BaseBatchProcessingOrchestrator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdater;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdater10;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdater40;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdater5;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdater60;

public class IssueNoteBatchUpdateOrchestrator
extends BaseBatchProcessingOrchestrator<IssueNoteBatchUpdater> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueNoteBatchUpdateOrchestrator.class);

    public IssueNoteBatchUpdateOrchestrator() {
        super(Arrays.asList(new IssueNoteBatchUpdater60(), new IssueNoteBatchUpdater40(), new IssueNoteBatchUpdater10(), new IssueNoteBatchUpdater5(), new SingleUpdater()));
    }

    public BatchUpdateResult updateNotes(GitLabClient client, List<NoteProcessInfo> notesToUpdate) {
        HashMap<String, List<String>> allErrors = new HashMap<String, List<String>>();
        this.processBatches(notesToUpdate, (processingUnit, batch) -> {
            Map<String, List<String>> errorsByIssueId = processingUnit.processBatch(client, batch);
            if (errorsByIssueId.values().stream().anyMatch(value -> !value.isEmpty())) {
                LOGGER.error(String.format("Encountered errors while updating GitLab note batches :%n%s", errorsByIssueId.values().stream().flatMap(Collection::stream).collect(Collectors.joining("\n"))));
                allErrors.putAll(errorsByIssueId);
            }
            DebugTimer.mark(String.format("Updated %d notes", processingUnit.getHandledBatchSize()));
        });
        return new BatchUpdateResult(allErrors);
    }

    public static final class BatchUpdateResult {
        private final Map<String, List<String>> errorsByIssueId;

        public BatchUpdateResult(Map<String, List<String>> errorsByIssueId) {
            this.errorsByIssueId = errorsByIssueId;
        }

        public Map<String, List<String>> getErrorsByIssueId() {
            return this.errorsByIssueId;
        }
    }

    static class SingleUpdater
    implements IssueNoteBatchUpdater {
        SingleUpdater() {
        }

        @Override
        public int getHandledBatchSize() {
            return 1;
        }

        @Override
        public Map<String, List<String>> processBatch(GitLabClient client, List<NoteProcessInfo> batch) {
            if (batch.size() != this.getHandledBatchSize()) {
                throw new IllegalStateException("Provided batch size doesn't match handled batch size.");
            }
            UpdateIssueNoteMutation mut = UpdateIssueNoteMutation.builder().id(batch.get((int)0).existingNoteGlobalId).body(batch.get((int)0).noteBody).build();
            return client.executeAndConvert(mut, data -> Collections.singletonMap(((NoteProcessInfo)list.get((int)0)).existingNoteGlobalId, Optional.ofNullable(data).map(UpdateIssueNoteMutation.Data::updateNote).map(UpdateIssueNoteMutation.UpdateNote::errors).orElse(Collections.emptyList())));
        }
    }
}

