/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.debug.DebugTimer;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GraphqlClientException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GraphqlTopLevelErrorsException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.CreateIssueNoteMutation;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.BaseBatchProcessingOrchestrator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreator10;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreator40;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreator5;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreator60;
import xsquash4gitlab.com.apollographql.apollo.api.Error;

public class IssueNoteBatchCreationOrchestrator
extends BaseBatchProcessingOrchestrator<IssueNoteBatchCreator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueNoteBatchCreationOrchestrator.class);
    private boolean shouldInterruptProcess = false;

    public IssueNoteBatchCreationOrchestrator() {
        super(Arrays.asList(new IssueNoteBatchCreator60(), new IssueNoteBatchCreator40(), new IssueNoteBatchCreator10(), new IssueNoteBatchCreator5(), new SingleCreator()));
    }

    public BatchCreationResult createNotes(GitLabClient client, List<NoteProcessInfo> notesToCreate) {
        this.shouldInterruptProcess = false;
        HashMap<String, List<String>> allErrors = new HashMap<String, List<String>>();
        this.processBatches(notesToCreate, (processingUnit, batch) -> this.doProcessBatch(client, (Map<String, List<String>>)allErrors, (IssueNoteBatchCreator)processingUnit, batch));
        return new BatchCreationResult(allErrors);
    }

    private void doProcessBatch(GitLabClient client, Map<String, List<String>> allErrors, IssueNoteBatchCreator processingUnit, List<NoteProcessInfo> batch) {
        if (this.shouldInterruptProcess) {
            batch.forEach(item -> {
                List<String> list = allErrors.put(item.issueGlobalId, Collections.singletonList("Batch aborted because of previous errors."));
            });
            return;
        }
        try {
            Map<String, List<String>> errorsByIssueId = processingUnit.processBatch(client, batch);
            if (errorsByIssueId.values().stream().anyMatch(value -> !value.isEmpty())) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error(String.format("Encountered errors while creating GitLab note batches :%n%s", errorsByIssueId.values().stream().flatMap(Collection::stream).collect(Collectors.joining("\n"))));
                }
                allErrors.putAll(errorsByIssueId);
            }
            DebugTimer.mark(String.format("Created %d notes", processingUnit.getHandledBatchSize()));
        }
        catch (GraphqlTopLevelErrorsException topLevelErrorsException) {
            LOGGER.error(topLevelErrorsException.getMessage());
            this.appendTopLevelErrors(allErrors, batch, topLevelErrorsException);
            this.interruptProcessIfUsageLimitWasReached(topLevelErrorsException.getTopLevelErrors());
        }
        catch (GraphqlClientException graphqlClientException) {
            LOGGER.error("A graphql error occurred during batch processing", (Throwable)((Object)graphqlClientException));
        }
    }

    private void interruptProcessIfUsageLimitWasReached(List<Error> errors) {
        if (errors.stream().anyMatch(error -> error.getMessage().contains("Try again later"))) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("The usage limit for the note creation endpoint was reached. The remaining work will be delayed.");
            }
            this.shouldInterruptProcess = true;
        }
    }

    private void appendTopLevelErrors(Map<String, List<String>> allErrors, List<NoteProcessInfo> batch, GraphqlTopLevelErrorsException topLevelErrorsException) {
        topLevelErrorsException.getTopLevelErrors().forEach(topLevelError -> {
            Object pathValue = topLevelError.getCustomAttributes().get("path");
            if (pathValue instanceof List && !((List)pathValue).isEmpty()) {
                this.extractQueryIndexFromErrorPath(batch, (List)pathValue).ifPresent(queryIndex -> {
                    String issueGlobalId = ((NoteProcessInfo)list.get((int)queryIndex.intValue())).issueGlobalId;
                    allErrors.put(issueGlobalId, Collections.singletonList(topLevelError.getMessage()));
                });
            }
        });
    }

    private Optional<Integer> extractQueryIndexFromErrorPath(List<NoteProcessInfo> batch, List<?> pathValue) {
        int queryIndex;
        String[] pathTokens;
        Object firstPathElement = pathValue.get(0);
        if (firstPathElement instanceof String && this.isPathToAliasedQuery(pathTokens = ((String)firstPathElement).split("_")) && (queryIndex = Integer.parseInt(pathTokens[1])) >= 0 && queryIndex < batch.size()) {
            return Optional.of(queryIndex);
        }
        return Optional.empty();
    }

    private boolean isPathToAliasedQuery(String[] pathTokens) {
        return pathTokens.length == 2 && pathTokens[0].equals("m");
    }

    public static final class BatchCreationResult {
        private final Map<String, List<String>> errorsByIssueId;

        public BatchCreationResult(Map<String, List<String>> errorsByIssueId) {
            this.errorsByIssueId = errorsByIssueId;
        }

        public Map<String, List<String>> getErrorsByIssueId() {
            return this.errorsByIssueId;
        }
    }

    static class SingleCreator
    implements IssueNoteBatchCreator {
        SingleCreator() {
        }

        @Override
        public int getHandledBatchSize() {
            return 1;
        }

        @Override
        public Map<String, List<String>> processBatch(GitLabClient client, List<NoteProcessInfo> batch) {
            if (batch.size() != this.getHandledBatchSize()) {
                throw new IllegalStateException("Provided batch size doesn't match handled batch size.");
            }
            CreateIssueNoteMutation mut = CreateIssueNoteMutation.builder().id(batch.get((int)0).issueGlobalId).body(batch.get((int)0).noteBody).build();
            return client.executeAndConvert(mut, data -> Collections.singletonMap(((NoteProcessInfo)list.get((int)0)).issueGlobalId, Optional.ofNullable(data.createNote()).map(CreateIssueNoteMutation.CreateNote::errors).orElse(Collections.emptyList())));
        }
    }
}

