/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.BatchProcessingUnit;

public abstract class BaseBatchProcessingOrchestrator<U extends BatchProcessingUnit> {
    protected final List<U> processingUnits;

    protected BaseBatchProcessingOrchestrator(List<U> processingUnits) {
        this.processingUnits = this.sortedByDescendingBatchSize(processingUnits);
        this.assertHasOneSizedBatchHandler();
    }

    protected <E> void processBatches(List<E> elements, BatchProcessingPerformer<U, E> performer) {
        int index = 0;
        block0: while (index < elements.size()) {
            int remainingCount = elements.size() - index;
            for (BatchProcessingUnit processingUnit : this.processingUnits) {
                int handledBatchSize = processingUnit.getHandledBatchSize();
                if (handledBatchSize > remainingCount) continue;
                List<E> batch = elements.subList(index, index + handledBatchSize);
                performer.delegateBatchProcessing(processingUnit, batch);
                index += handledBatchSize;
                continue block0;
            }
        }
    }

    private List<U> sortedByDescendingBatchSize(List<U> processingUnits) {
        return processingUnits.stream().sorted(Comparator.comparingInt(BatchProcessingUnit::getHandledBatchSize).reversed()).collect(Collectors.toList());
    }

    private void assertHasOneSizedBatchHandler() {
        for (BatchProcessingUnit unit : this.processingUnits) {
            if (unit.getHandledBatchSize() != 1) continue;
            return;
        }
        throw new IllegalStateException("A batch processing orchestrator must define a 1-sized batch processing unit.");
    }

    @FunctionalInterface
    public static interface BatchProcessingPerformer<U extends BatchProcessingUnit, E> {
        public void delegateBatchProcessing(U var1, List<E> var2);
    }
}

