/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.execplan;

import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.QIssue;
import org.squashtest.tm.domain.campaign.QCampaign;
import org.squashtest.tm.domain.campaign.QCampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.QIteration;
import org.squashtest.tm.domain.campaign.QIterationTestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.execution.QExecution;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.testcase.QRequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanGitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanRequirement;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.SelectedNode;

@Repository(value="squash.tm.plugin.xsquash4gitlab.execplandao")
public class ExecPlanSynchronizationDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext DSL;
    @Inject
    private CurrentUserHelper currentUserHelper;
    private static final String LOAD_SELECTED_NODE_CPG = "select c.id, 'campaign', c.name, p.id, p.name from Campaign c join c.project p where c.id = :id";
    private static final String LOAD_SELECTED_NODE_IT = "select  it.id, 'iteration', it.name, p.id, p.name from Iteration it join it.campaign c join c.project p where it.id = :id";
    private static final String FIND_ITERATION_NAMES = "select it.name from Iteration it join it.campaign c where c.id = :id";
    private static final String FIND_ITERATION_CUFS = "select cuf from CustomFieldBinding binding join binding.customField cuf join binding.boundProject project where project.id = ( select cpro.id from Campaign c join c.project cpro where c.id = :cpgId ) and binding.boundEntity = :boundEntity order by binding.position asc";
    private static final String FIND_SYNCED_SERVERS = "select distinct serv from RemoteSynchronisation sync join sync.server serv where sync.kind = 'squash.tm.plugin.xsquash4gitlab'";
    private static final String FILTER_SYNC_KEY = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync where sync.kind = 'squash.tm.plugin.xsquash4gitlab' and extender.remoteReqId in (:keys)";
    private static final String FILTER_BUGFIXES_KEY = "select distinct issue.remoteIssueId from Issue issue left join BugTracker bt on bt.id = issue.bugtracker.id where issue.remoteIssueId in (:keys) and bt.kind = 'gitlab.bugtracker'";
    private static final String FILTER_COVERED_REQS = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync inner join extender.requirement req inner join req.versions versions inner join versions.requirementVersionCoverages cov where sync.kind = 'squash.tm.plugin.xsquash4gitlab' and extender.remoteReqId in (:keys)";

    public SelectedNode loadSelectedNode(EntityReference reference) {
        Long id = reference.getId();
        return this.loadSelectedNode(switch (reference.getType()) {
            case EntityType.CAMPAIGN -> LOAD_SELECTED_NODE_CPG;
            case EntityType.ITERATION -> LOAD_SELECTED_NODE_IT;
            default -> throw new IllegalArgumentException("Entity Type '" + reference.getType() + "' is not yet supported");
        }, id);
    }

    private SelectedNode loadSelectedNode(String hql, Long entityId) {
        Object[] tuple = (Object[])this.em.createQuery(hql).setParameter("id", (Object)entityId).getSingleResult();
        SelectedNode node = new SelectedNode();
        node.setEntityId((Long)tuple[0]);
        node.setType((String)tuple[1]);
        node.setEntityName((String)tuple[2]);
        node.setProjectId((Long)tuple[3]);
        node.setProjectName((String)tuple[4]);
        return node;
    }

    public boolean isWizardEnabledOnProject(long projectId) {
        return (Integer)this.DSL.selectCount().from((TableLike)Tables.LIBRARY_PLUGIN_BINDING).leftJoin((TableLike)Project.PROJECT).on(Project.PROJECT.CL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID)).where(Project.PROJECT.PROJECT_ID.equal((Object)projectId).and(Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID.equal((Object)"squash.tm.plugin.xsquash4gitlab")).and(Tables.LIBRARY_PLUGIN_BINDING.ACTIVE.eq((Object)true))).fetchOne(0, Integer.class) > 0;
    }

    public List<BugTracker> findAllGitLabServers() {
        return this.em.createQuery(FIND_SYNCED_SERVERS).getResultList();
    }

    public Collection<Long> findTestCasesAlreadyPlannedInCampaign(long campaignId) {
        QCampaign cpg = QCampaign.campaign;
        QCampaignTestPlanItem item = QCampaignTestPlanItem.campaignTestPlanItem;
        QTestCase tc = QTestCase.testCase;
        JPAQuery query = new JPAQuery(this.em);
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select((Expression)tc.id).from((EntityPath)item)).innerJoin((EntityPath)item.campaign, (Path)cpg)).innerJoin((EntityPath)item.referencedTestCase, (Path)tc)).where((Predicate)cpg.id.eq((Object)campaignId));
        return query.fetch();
    }

    public Collection<Long> findTestCasesAlreadyPlannedInIteration(long iterationId) {
        QIteration it = QIteration.iteration;
        QIterationTestPlanItem item = QIterationTestPlanItem.iterationTestPlanItem;
        QTestCase tc = QTestCase.testCase;
        JPAQuery query = new JPAQuery(this.em);
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select((Expression)tc.id).from((EntityPath)item)).innerJoin((EntityPath)item.iteration, (Path)it)).innerJoin((EntityPath)item.referencedTestCase, (Path)tc)).where((Predicate)it.id.eq((Object)iterationId));
        return query.fetch();
    }

    public List<String> findIterationNamesForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_NAMES).setParameter("id", (Object)campaignId).getResultList();
    }

    public List<CustomField> findIterationCutomfieldsForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_CUFS).setParameter("cpgId", (Object)campaignId).setParameter("boundEntity", (Object)BindableEntity.ITERATION).getResultList();
    }

    public Set<String> filterFeatures(List<String> keys2) {
        if (keys2.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_SYNC_KEY).setParameter("keys", keys2).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterBugfixes(List<String> keys2) {
        if (keys2.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_BUGFIXES_KEY).setParameter("keys", keys2).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterCoveredFeatures(List<String> keys2) {
        if (keys2.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_COVERED_REQS).setParameter("keys", keys2).getResultList();
        return new HashSet<String>(res);
    }

    public List<ExecplanTestCase> findTestCasesFixedBy(Collection<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return Collections.emptyList();
        }
        QTestCase tc = QTestCase.testCase;
        QExecution exec = QExecution.execution;
        QIssue issue = QIssue.issue;
        Map result = (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select(new Expression[]{tc.id, tc.name, tc.reference, issue.remoteIssueId}).from((EntityPath)exec)).innerJoin((CollectionExpression)exec.issues, (Path)issue)).innerJoin((EntityPath)exec.referencedTestCase, (Path)tc)).where(new Predicate[]{issue.remoteIssueId.in(issueKeys), tc.project.id.in((Collection)this.currentUserHelper.findReadableProjectIds())})).transform(GroupBy.groupBy((Expression)Projections.constructor(ExecplanTestCase.class, (Expression[])new Expression[]{tc.id, tc.name, tc.reference})).as((Expression)GroupBy.list((Expression)Projections.constructor(ExecplanGitLabIssue.class, (Expression[])new Expression[]{issue.remoteIssueId}))));
        return result.entrySet().stream().map(entry -> {
            ExecplanTestCase ctc = (ExecplanTestCase)entry.getKey();
            List cissues = (List)entry.getValue();
            ctc.setIssues(cissues);
            return ctc;
        }).collect(Collectors.toList());
    }

    public List<ExecplanTestCase> findTestCasesCoveringFeatures(Collection<String> issueKeys) {
        if (issueKeys.isEmpty()) {
            return Collections.emptyList();
        }
        QTestCase tc = QTestCase.testCase;
        QRequirementVersionCoverage cov = QRequirementVersionCoverage.requirementVersionCoverage;
        QRequirementVersion ver = QRequirementVersion.requirementVersion;
        QRequirement req = QRequirement.requirement;
        QRequirementSyncExtender ext = QRequirementSyncExtender.requirementSyncExtender;
        Map result = (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select(new Expression[]{tc.id, tc.name, tc.reference, ver.id, ver.reference, ext.remoteReqId}).from((EntityPath)tc)).innerJoin((CollectionExpression)tc.requirementVersionCoverages, (Path)cov)).innerJoin((EntityPath)cov.verifiedRequirementVersion, (Path)ver)).innerJoin((EntityPath)ver.requirement, (Path)req)).innerJoin((EntityPath)req.syncExtender, (Path)ext)).where(new Predicate[]{ext.remoteReqId.in(issueKeys), tc.project.id.in((Collection)this.currentUserHelper.findReadableProjectIds())})).transform(GroupBy.groupBy((Expression)Projections.constructor(ExecplanTestCase.class, (Expression[])new Expression[]{tc.id, tc.name, tc.reference})).as((Expression)GroupBy.list((Expression)Projections.constructor(ExecplanRequirement.class, (Expression[])new Expression[]{ver.id, ver.reference, ext.remoteReqId}))));
        return result.entrySet().stream().map(entry -> {
            ExecplanTestCase ctc = (ExecplanTestCase)entry.getKey();
            List creqs = (List)entry.getValue();
            ctc.setRequirements(creqs);
            return ctc;
        }).collect(Collectors.toList());
    }
}

