/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtenderType;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.RequirementFolderSyncExtenderDto;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.repository.GitLabFolderSyncExtenderDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SyncedRequirementPathHelper;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;

@Service(value="squash.tm.plugin.xsquash4gitlab.SynchronizedFolderService")
@Transactional
public class SynchronizedFolderService {
    private final GitLabFolderSyncExtenderDao gitLabFolderSyncExtenderDao;
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    @PersistenceContext
    private EntityManager entityManager;

    public SynchronizedFolderService(GitLabFolderSyncExtenderDao gitLabFolderSyncExtenderDao, RequirementLibraryNavigationService requirementLibraryNavigationService) {
        this.gitLabFolderSyncExtenderDao = gitLabFolderSyncExtenderDao;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
    }

    public Long prepareRootTargetFolder(RemoteSynchronisation remoteSynchronisation) {
        RequirementFolderSyncExtenderDto extender = this.gitLabFolderSyncExtenderDao.findRootReqFolderByRemoteSynchronisationId(remoteSynchronisation.getId());
        if (extender != null) {
            return extender.getRequirementFolderId();
        }
        String synchronisationPath = GitLabRemoteSynchronisation.getSynchronisationPath(remoteSynchronisation);
        Long newFolderId = this.createFolderOrGetId(synchronisationPath);
        this.createSyncExtender(newFolderId, remoteSynchronisation, RequirementFolderSyncExtenderType.TARGET);
        return newFolderId;
    }

    public Long getRootTargetFolderId(RemoteSynchronisation remoteSynchronisation) {
        if (remoteSynchronisation == null) {
            throw new IllegalArgumentException("Expected a non-null remote synchronisation");
        }
        RequirementFolderSyncExtenderDto extender = this.gitLabFolderSyncExtenderDao.findRootReqFolderByRemoteSynchronisationId(remoteSynchronisation.getId());
        if (extender == null) {
            throw new IllegalStateException("Expected a synchronised folder to exist for remote sync with ID " + remoteSynchronisation.getId());
        }
        return extender.getRequirementFolderId();
    }

    public void prepareSubFolders(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, List<GitLabIssue> gitLabIssues) {
        Set<String> foldersToCreate = SyncedRequirementPathHelper.getTargetPaths(gitLabRemoteSynchronisation, gitLabIssues);
        switch (gitLabRemoteSynchronisation.getSyncedRequirementHierarchy()) {
            case ITERATION: {
                this.createSubFoldersForIterations(foldersToCreate, gitLabRemoteSynchronisation, gitLabIssues);
                break;
            }
            case MILESTONE: {
                this.createSubFoldersForMilestones(foldersToCreate, gitLabRemoteSynchronisation, gitLabIssues);
                break;
            }
            case TREE: {
                this.createSubFoldersForTree(gitLabRemoteSynchronisation, foldersToCreate);
                break;
            }
        }
    }

    private void createSubFoldersForIterations(Set<String> foldersToCreate, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, List<GitLabIssue> gitLabIssues) {
        foldersToCreate.forEach(folder -> {
            Optional<String> iterationId = gitLabIssues.stream().map(GitLabIssue::getIteration).filter(iteration -> Objects.nonNull(iteration) && folder.equals(iteration.getIterationFolderPath())).map(iteration -> SynchronizedFolderService.extractIdAsStringFromGitLabId(iteration.getId())).findFirst();
            iterationId.ifPresent(remoteId -> {
                RequirementFolderSyncExtenderDto extender = this.gitLabFolderSyncExtenderDao.findSprintReqFolderByRemoteSyncIdAndRemoteSprintId(gitLabRemoteSynchronisation.getRemoteSynchronisation().getId(), (String)remoteId);
                if (extender == null) {
                    String folderPath = this.getFolderPath(gitLabRemoteSynchronisation, (String)folder);
                    Long newFolderId = this.createFolderOrGetId(folderPath);
                    this.createSyncExtender(newFolderId, (String)remoteId, gitLabRemoteSynchronisation.getRemoteSynchronisation(), RequirementFolderSyncExtenderType.SPRINT);
                }
            });
        });
    }

    private void createSubFoldersForMilestones(Set<String> foldersToCreate, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, List<GitLabIssue> gitLabIssues) {
        foldersToCreate.forEach(folder -> {
            Optional<String> milestoneId = gitLabIssues.stream().map(GitLabIssue::getMilestone).filter(milestone -> Objects.nonNull(milestone) && folder.equals(milestone.getTitleForPath())).map(milestone -> SynchronizedFolderService.extractIdAsStringFromGitLabId(milestone.getId())).findFirst();
            milestoneId.ifPresent(remoteId -> {
                RequirementFolderSyncExtenderDto extender = this.gitLabFolderSyncExtenderDao.findSprintReqFolderByRemoteSyncIdAndRemoteSprintId(gitLabRemoteSynchronisation.getRemoteSynchronisation().getId(), (String)remoteId);
                String folderPath = this.getFolderPath(gitLabRemoteSynchronisation, (String)folder);
                if (extender == null) {
                    Long newFolderId = this.createFolderOrGetId(folderPath);
                    this.createSyncExtender(newFolderId, (String)remoteId, gitLabRemoteSynchronisation.getRemoteSynchronisation(), RequirementFolderSyncExtenderType.SPRINT);
                }
            });
        });
    }

    private void createSubFoldersForTree(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, Set<String> foldersToCreate) {
        foldersToCreate.forEach(folder -> {
            String folderPath = this.getFolderPath(gitLabRemoteSynchronisation, (String)folder);
            this.createFolderOrGetId(folderPath);
        });
    }

    private String getFolderPath(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String folder) {
        return String.format("%s/%s", gitLabRemoteSynchronisation.getSynchronisationPath(), folder);
    }

    public Long createFolderOrGetId(String folderPath) {
        return this.requirementLibraryNavigationService.mkdirs(folderPath);
    }

    public void createSyncExtender(Long folderId, RemoteSynchronisation remoteSynchronisation, RequirementFolderSyncExtenderType type) {
        this.createSyncExtender(folderId, null, remoteSynchronisation, type);
    }

    public void createSyncExtender(Long folderId, String remoteFolderId, RemoteSynchronisation remoteSynchronisation, RequirementFolderSyncExtenderType type) {
        RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)folderId);
        RequirementFolderSyncExtender syncExtender = new RequirementFolderSyncExtender();
        syncExtender.setRequirementFolder(requirementFolder);
        syncExtender.setType(type);
        syncExtender.setRemoteFolderId(remoteFolderId);
        syncExtender.setRemoteSynchronisation(remoteSynchronisation);
        this.entityManager.persist((Object)syncExtender);
    }

    public static String extractIdAsStringFromGitLabId(String gitLabId) {
        String[] parts = gitLabId.split("/");
        return parts[parts.length - 1];
    }
}

