/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.NoCredentialsException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientPool;
import org.squashtest.tm.service.servers.CredentialsProvider;

@Service
public class GitLabClientProvider {
    private static final String GRAPHQL_ENDPOINT = "api/graphql";
    private final CredentialsProvider credentialsProvider;
    private final GitLabClientPool gitLabClientPool;
    @PersistenceContext
    EntityManager em;

    public GitLabClientProvider(CredentialsProvider credentialsProvider) throws IllegalArgumentException {
        this.credentialsProvider = credentialsProvider;
        this.gitLabClientPool = new GitLabClientPool();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public GitLabClient getGitLabClient(Long bugTrackerId) {
        BugTracker bugTracker = (BugTracker)this.em.find(BugTracker.class, (Object)bugTrackerId);
        String token = this.getToken(bugTracker);
        String endpoint = this.buildGraphQlEndpointUrl(bugTracker.getUrl());
        return this.gitLabClientPool.getClient(endpoint, token);
    }

    private String getToken(BugTracker bugTracker) {
        TokenAuthCredentials credentials = this.getCredentials(bugTracker);
        return credentials.getToken();
    }

    private TokenAuthCredentials getCredentials(BugTracker bugTracker) {
        Credentials credentials = (Credentials)this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)bugTracker).orElseThrow(() -> new NoCredentialsException(bugTracker.getId().toString()));
        if (TokenAuthCredentials.class.isAssignableFrom(credentials.getClass())) {
            return (TokenAuthCredentials)credentials;
        }
        throw new IllegalArgumentException("Expected token auth credentials for server with ID " + bugTracker.getId());
    }

    private String buildGraphQlEndpointUrl(String serverUrl) {
        String urlBase = serverUrl;
        if (!urlBase.endsWith("/")) {
            urlBase = String.valueOf(urlBase) + "/";
        }
        return String.format("%s%s", urlBase, GRAPHQL_ENDPOINT);
    }
}

