/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.jackson.model.CheckingAttributeTestStepDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.service.RestTestStepService;
import org.squashtest.tm.plugin.rest.validators.helper.TestStepValidationHelper;

@Component
public class TestStepPatchValidator
implements Validator {
    @Inject
    private RestTestStepService restTestStepService;
    @Inject
    private TestStepValidationHelper testStepValidationHelper;

    public boolean supports(Class<?> clazz) {
        return TestStepDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestStepDto patch = (TestStepDto)target;
        this.checkIfExist(errors, patch.getId());
        CheckingAttributeTestStepDtoVisitor visitor = new CheckingAttributeTestStepDtoVisitor(this.testStepValidationHelper, errors);
        try {
            patch.accept(visitor);
        }
        catch (BindException e) {
            e.printStackTrace();
        }
        this.checkForbiddenPatchAttributes(errors, patch);
    }

    private void checkIfExist(Errors errors, long id) {
        TestStep testStep = this.restTestStepService.getOne(id);
        if (testStep == null) {
            String message = String.format("No test step known for id %d", id);
            errors.rejectValue("id", "invalid id", message);
        }
    }

    private void checkForbiddenPatchAttributes(Errors errors, TestStepDto patch) {
        if (patch.getTestCaseDto() != null) {
            errors.rejectValue("testCase", "non patchable attribute", "Only attributes belonging to the test step itself can be modified. The attribute test case cannot be patched. Use direct url to the test case entity instead");
        }
    }
}

