/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.IterationDto;
import org.squashtest.tm.plugin.rest.validators.helper.IterationValidationHelper;

@Component
public class IterationPostValidator
implements Validator {
    private static final String NON_POSTABLE_ATTRIBUTE = "non postable attribute";
    @Inject
    private IterationValidationHelper iterationValidationHelper;

    public boolean supports(Class<?> clazz) {
        return IterationDto.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        IterationDto iterationDto = (IterationDto)target;
        if (iterationDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing iteration, please do a patch request to the iteration id. ");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        this.iterationValidationHelper.checkProject(iterationDto);
        this.iterationValidationHelper.checkAndAssignStatus(errors, iterationDto);
        List<CustomFieldValueDto> customFieldValueDtos = iterationDto.getCustomFields();
        this.iterationValidationHelper.checkCufs(errors, customFieldValueDtos, iterationDto.getProjectId(), BindableEntity.ITERATION);
        this.checkForbiddenPostAttributes(errors, iterationDto);
    }

    private void checkForbiddenPostAttributes(Errors errors, IterationDto post) {
        if (post.getTestSuites() != null) {
            errors.rejectValue("test-suites", NON_POSTABLE_ATTRIBUTE, "Only attributes belonging to the iteration itself can be posted. The attribute test suite cannot be posted. Use direct url to the test suites entity instead");
        }
        if (post.getTestPlan() != null) {
            errors.rejectValue("test-plan", NON_POSTABLE_ATTRIBUTE, "Only attributes belonging to the iteration itself can be posted. The attribute test plan cannot be posted. Use direct url to the test plan entity instead");
        }
    }
}

