/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.repository.RestExploratoryExecutionRepository;
import org.squashtest.tm.plugin.rest.service.RestExploratoryExecutionService;

@Service
@Transactional
public class RestExploratoryExecutionServiceImpl
implements RestExploratoryExecutionService {
    @Inject
    private RestExploratoryExecutionRepository exploratoryExecutionRepository;
    @Inject
    private DSLContext dsl;

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.execution.Execution' , 'READ')")
    @Transactional(readOnly=true)
    public ExploratoryExecution getOne(long id) {
        return (ExploratoryExecution)this.exploratoryExecutionRepository.getReferenceById(id);
    }

    @Override
    public String getCharterByExploratoryExecutionId(long exploratoryExecutionId) {
        return (String)this.dsl.select((SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.CHARTER).from((TableLike)Tables.EXPLORATORY_EXECUTION).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID)).where(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Object)exploratoryExecutionId)).fetchOneInto(String.class);
    }

    @Override
    public List<ExploratoryExecution> getExploratoryExecutionFromIssues(String remoteIssueId, List<Long> executionIds) {
        return this.dsl.selectDistinct((SelectField)Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.as("ID")).from((TableLike)Tables.EXPLORATORY_EXECUTION).join((TableLike)Tables.EXECUTION).on(Tables.EXPLORATORY_EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).join((TableLike)Tables.ISSUE).on(Tables.ISSUE.ISSUE_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID)).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.in(executionIds).and(Tables.ISSUE.REMOTE_ISSUE_ID.eq((Object)remoteIssueId))).fetchInto(ExploratoryExecution.class);
    }
}

