/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.jackson.model.ExecutionStepAndCustomFields;
import org.squashtest.tm.plugin.rest.repository.RestExecutionStepRepository;
import org.squashtest.tm.plugin.rest.service.RestExecutionStepService;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;

@Service
@Transactional
public class RestExecutionStepServiceImpl
implements RestExecutionStepService {
    @Inject
    private RestExecutionStepRepository dao;
    @Inject
    private ExecutionProcessingService executionProcessingService;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;
    @Inject
    private DSLContext dslContext;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.execution.ExecutionStep' , 'READ')")
    public ExecutionStep getOne(long id) {
        return (ExecutionStep)this.dao.getReferenceById(id);
    }

    @Override
    public void modifyExecutionStatus(Long executionStepId, ExecutionStatus status) {
        this.executionProcessingService.changeExecutionStepStatus(executionStepId, status);
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#step.wrapped , 'EXECUTE')")
    public void updateStep(ExecutionStepAndCustomFields step) {
        this.internalCufService.mergeCustomFields(step);
    }

    @Override
    public List<ExecutionStep> getExecutionStepFromIssue(String remoteIssueId, Long executionId) {
        return this.dslContext.select((SelectField)Tables.EXECUTION_STEP.EXECUTION_STEP_ID.as("ID"), (SelectField)Tables.EXECUTION_STEP.ACTION).from((TableLike)Tables.EXECUTION_STEP).join((TableLike)Tables.ISSUE_LIST).on(Tables.ISSUE_LIST.ISSUE_LIST_ID.eq((Field)Tables.EXECUTION_STEP.ISSUE_LIST_ID)).join((TableLike)Tables.ISSUE).on(Tables.ISSUE.ISSUE_LIST_ID.eq((Field)Tables.ISSUE_LIST.ISSUE_LIST_ID)).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).where(Tables.ISSUE.REMOTE_ISSUE_ID.eq((Object)remoteIssueId)).and(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Object)executionId)).fetchInto(ExecutionStep.class);
    }

    @Override
    public List<Execution> getExecutionFromExecutionStep(Long executionStepId) {
        return this.dslContext.select((SelectField)Tables.EXECUTION.EXECUTION_ID.as("ID")).from((TableLike)Tables.EXECUTION).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID)).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).where(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Object)executionStepId)).fetchInto(Execution.class);
    }
}

