/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.environmentvariable.DenormalizedEnvironmentVariable;
import org.squashtest.tm.plugin.rest.jackson.model.DenormalizedEnvironmentVariableDto;
import org.squashtest.tm.plugin.rest.service.RestEnvironmentVariablesService;

@Component
public class EnvironmentVariablePropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    private RestEnvironmentVariablesService variableService;

    public EnvironmentVariablePropertyWriter() {
    }

    public EnvironmentVariablePropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, RestEnvironmentVariablesService variableService) {
        super(propDef, contextAnnotations, declaredType);
        this.variableService = variableService;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        ArrayList<DenormalizedEnvironmentVariableDto> environmentVariableData = new ArrayList<DenormalizedEnvironmentVariableDto>();
        if (this.variableService != null) {
            List<DenormalizedEnvironmentVariable> values = this.variableService.findAllDenormalizedEnvironmentVariableBoundToExecution((BoundEntity)bean);
            for (DenormalizedEnvironmentVariable denormalizedEnvironmentVariable : values) {
                environmentVariableData.add(new DenormalizedEnvironmentVariableDto(denormalizedEnvironmentVariable));
            }
        }
        return environmentVariableData;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType) {
        return new EnvironmentVariablePropertyWriter(beanPropertyDefinition, annotatedClass.getAnnotations(), javaType, this.variableService);
    }
}

