/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.DisableSort;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.TestCaseTypeFilter;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.service.RestDatasetService;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestParameterService;
import org.squashtest.tm.plugin.rest.service.RestTestCaseService;
import org.squashtest.tm.plugin.rest.service.RestVerifyingRequirementManagerService;
import org.squashtest.tm.plugin.rest.validators.TestCasePatchValidator;
import org.squashtest.tm.plugin.rest.validators.TestCasePostValidator;

@RestApiController(value=TestCase.class)
@UseDefaultRestApiConfiguration
public class RestTestCaseController
extends BaseRestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTestCaseController.class);
    private static final String POST_TEST_CASE = "post-test-case";
    private static final String PATCH_TEST_CASE = "patch-test-case";
    public static final String LINK_REQUIREMENTS = "link-requirements";
    public static final String UNLINK_REQUIREMENTS = "unlink-requirements";
    @Inject
    private RestTestCaseService restTestCaseService;
    @Inject
    private RestParameterService restParameterService;
    @Inject
    private RestDatasetService restDatasetService;
    @Inject
    private TestCasePostValidator testCasePostValidator;
    @Inject
    private TestCasePatchValidator testCasePatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestVerifyingRequirementManagerService restVerifyingRequirementManagerService;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/test-cases"})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference")
    public ResponseEntity<PagedModel<EntityModel<TestCase>>> getAllReadableTestCases(Pageable pageable, TestCaseTypeFilter type) {
        Page<TestCase> tcs = switch (type) {
            case TestCaseTypeFilter.STANDARD -> this.restTestCaseService.getAllStandardTestCases(pageable);
            case TestCaseTypeFilter.SCRIPTED -> this.restTestCaseService.getAllScriptedTestCases(pageable);
            case TestCaseTypeFilter.KEYWORD -> this.restTestCaseService.getAllKeywordTestCases(pageable);
            case TestCaseTypeFilter.EXPLORATORY -> this.restTestCaseService.getAllExploratoryTestCases(pageable);
            default -> this.restTestCaseService.getAllReadableTestCases(pageable);
        };
        SingleRelPagedResources res = this.toPagedResourcesWithRel(tcs, "test-cases");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-cases/{id}"})
    @EntityGetter(value={TestCase.class, ScriptedTestCase.class, KeywordTestCase.class, ExploratoryTestCase.class})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name],  verified_requirements[name], parameters[name], datasets[name], automated_test[name],steps[*, called_test_case[name], called_dataset[name], -test_case], attachments[name]")
    public ResponseEntity<EntityModel<TestCase>> findTestCase(@PathVariable(value="id") long id) {
        TestCase tc = this.restTestCaseService.getOne(id);
        EntityModel res = this.toEntityModel((Identified)tc);
        this.linksHelper.addAllLinksForTestCase((EntityModel<TestCase>)res);
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-cases/{id}/steps"})
    @ResponseBody
    @DynamicFilterExpression(value="*, called_test_case[name], -test_case, verified_requirements[name]")
    public ResponseEntity<PagedModel<EntityModel<TestStep>>> findTestCaseSteps(@PathVariable(value="id") long tcid, @DisableSort Pageable pageable) {
        Page<TestStep> steps = this.restTestCaseService.getTestCaseSteps(tcid, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "steps");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-cases/{id}/parameters"})
    @ResponseBody
    @DynamicFilterExpression(value="*, test_case[name]")
    public ResponseEntity<PagedModel<EntityModel<Parameter>>> findTestCaseParameters(@PathVariable(value="id") long id, Pageable pageable) {
        Page<Parameter> parameters = this.restParameterService.findAllByTestCaseId(id, pageable);
        PagedModel res = this.toPagedModel(parameters);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-cases/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findTestCaseIssues(@PathVariable(value="id") long id, Pageable pageable) {
        List<Long> executionIds = this.restTestCaseService.getExecutionIdsByTestCase(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-cases/{id}/datasets"})
    @ResponseBody
    @DynamicFilterExpression(value="*,parameters[name],-test_case")
    public ResponseEntity<PagedModel<EntityModel<Dataset>>> findTestCaseDatasets(@PathVariable(value="id") long id, Pageable pageable) {
        Page<Dataset> datasets = this.restDatasetService.findAllByTestCaseId(id, pageable);
        PagedModel res = this.toPagedModel(datasets);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/test-cases"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name], verified_requirements[name], parameters[name], steps[*, called_test_case[name], -test_case ]")
    public ResponseEntity<EntityModel<TestCase>> createTestCase(@RequestBody TestCaseDto testCaseDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.validatePostTestCase(testCaseDto);
        TestCase tc = this.restTestCaseService.createTestCase(testCaseDto);
        EntityModel res = this.toEntityModel((Identified)tc);
        this.linksHelper.addAllLinksForTestCase((EntityModel<TestCase>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/test-cases/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name], verified_requirements[name], parameters[name], steps[*, called_test_case[name], -test_case ]")
    public ResponseEntity<EntityModel<TestCase>> patchTestCase(@RequestBody TestCaseDto patch, @PathVariable(value="id") long id) throws BindException {
        patch.setId(id);
        this.validatePatchTestCase(patch);
        TestCase tc = this.restTestCaseService.patchTestCase(patch, id);
        EntityModel res = this.toEntityModel((Identified)tc);
        this.linksHelper.addAllLinksForTestCase((EntityModel<TestCase>)res);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @DeleteMapping(value={"/test-cases/{ids}"})
    public ResponseEntity<List<String>> deleteTestCase(@PathVariable(value="ids") List<Long> testCaseIds, @RequestParam(name="dry-run", required=false) Boolean dryRun, Locale locale) {
        List<String> reportMessages = this.restTestCaseService.deleteTestCase(testCaseIds, dryRun, locale);
        return ResponseEntity.ok(reportMessages);
    }

    @ResponseBody
    @PostMapping(value={"/test-cases/{id}/coverages/{requirementIds}"})
    @DynamicFilterExpression(value="*, parent[name], project[name], verified_requirements[name], parameters[name], steps[*, called_test_case[name], -test_case ]")
    public ResponseEntity<EntityModel<TestCase>> linkRequirements(@PathVariable(value="id") Long testCaseId, @PathVariable(value="requirementIds") List<Long> requirementIds) throws BindException {
        this.testCasePostValidator.validateRequirements(testCaseId, requirementIds, LINK_REQUIREMENTS);
        TestCase testCase = this.restTestCaseService.getOne(testCaseId);
        this.restVerifyingRequirementManagerService.linkRequirementsToTestCase(requirementIds, testCaseId);
        EntityModel res = this.toEntityModel((Identified)testCase);
        this.linksHelper.addAllLinksForTestCase((EntityModel<TestCase>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/test-cases/{id}/coverages/{requirementIds}"})
    public ResponseEntity<Void> unlinkRequirementFromTestCase(@PathVariable(value="id") Long testCaseId, @PathVariable(value="requirementIds") List<Long> requirementIds) throws BindException {
        this.testCasePostValidator.validateRequirements(testCaseId, requirementIds, UNLINK_REQUIREMENTS);
        this.restVerifyingRequirementManagerService.unlinkRequirementsFromTestCase(requirementIds, testCaseId);
        return ResponseEntity.noContent().build();
    }

    private void validatePostTestCase(TestCaseDto testCaseDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)testCaseDto, POST_TEST_CASE);
        this.testCasePostValidator.validate(testCaseDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        this.testCasePostValidator.validateParameters(testCaseDto, errors, (BindingResult)validation);
        this.testCasePostValidator.validateTestSteps(testCaseDto, errors, (BindingResult)validation);
        ErrorHandlerHelper.throwIfError(testCaseDto, errors, POST_TEST_CASE);
    }

    private void validatePatchTestCase(TestCaseDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, PATCH_TEST_CASE);
        this.testCasePatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, PATCH_TEST_CASE);
    }
}

