/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.KeywordExecution;
import org.squashtest.tm.domain.execution.ScriptedExecution;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationFilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.PersistentEntity;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ExecutionAndCustomFields;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDtoForExecution;
import org.squashtest.tm.plugin.rest.service.RestExecutionService;
import org.squashtest.tm.plugin.rest.service.RestExecutionStepService;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.validators.CustomFieldValueHintedValidator;
import org.squashtest.tm.plugin.rest.validators.DenormalizedFieldValueHintedValidator;
import org.squashtest.tm.plugin.rest.validators.ExecutionHintedValidator;

@RestApiController(value=Execution.class)
@UseDefaultRestApiConfiguration
public class RestExecutionController
extends BaseRestController {
    public static final String FILTER_OUT_EXPLORATORY_EXECUTION_FIELDS = "-progress_status,-charter,-task_division,-session_notes,-reviewed,-execution_events";
    public static final String EXECUTION_DYNAMIC_FILTER = "*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]-progress_status,-charter,-task_division,-session_notes,-reviewed,-execution_events";
    public static final String PATCH_DYNAMIC_FILTER = "comment, execution_status, custom_fields";
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestExecutionService restExecutionService;
    @Inject
    private CustomFieldValueHintedValidator cufValidator;
    @Inject
    private DenormalizedFieldValueHintedValidator denoValidator;
    @Inject
    private ExecutionHintedValidator execValidator;
    @Inject
    private RestIssueService restIssueService;
    @Inject
    private RestExecutionStepService restExecutionStepService;

    public void initBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.execValidator});
        binder.addValidators(new Validator[]{this.cufValidator});
        binder.addValidators(new Validator[]{this.denoValidator});
    }

    @GetMapping(value={"/executions/{id}"})
    @EntityGetter(value={Execution.class, ScriptedExecution.class, KeywordExecution.class})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]-progress_status,-charter,-task_division,-session_notes,-reviewed,-execution_events")
    public ResponseEntity<EntityModel<Execution>> findExecution(@PathVariable(value="id") long id) {
        Execution execution = this.restExecutionService.getOne(id);
        if (execution.getExecutionMode() == TestCaseExecutionMode.EXPLORATORY) {
            throw new IllegalArgumentException("Execution " + id + " is an exploratory execution and cannot be retrieved. Please use the dedicated endpoint : /exploratory-executions/" + id);
        }
        EntityModel res = this.toEntityModel((Identified)execution);
        this.linksHelper.addAllLinksForExecution((EntityModel<Execution>)res);
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @PatchMapping(value={"/executions/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*,execution_steps[execution_status,action,expected_result], nature[code], type[code], automated_execution_extender[result_url, result_status]-progress_status,-charter,-task_division,-session_notes,-reviewed,-execution_events")
    @DeserializationFilterExpression(value="comment, execution_status, custom_fields")
    public ResponseEntity<EntityModel<Execution>> patchExecution(@Validated @PersistentEntity ExecutionAndCustomFields exec) {
        this.restExecutionService.updateExecution(exec);
        EntityModel res = this.toEntityModel((Identified)((Execution)exec.getWrapped()));
        this.linksHelper.addAllLinksForExecution((EntityModel<Execution>)res);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/executions/{id}/execution-steps"})
    @ResponseBody
    @DynamicFilterExpression(value="*, execution[execution_status]")
    public ResponseEntity<PagedModel<EntityModel<ExecutionStep>>> findExecutionSteps(@PathVariable(value="id") long executionId, Pageable pageable) {
        Page<ExecutionStep> steps = this.restExecutionService.findExecutionSteps(executionId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "execution-steps");
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/executions/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> deleteExecution(@PathVariable(value="id") Long executionId) {
        this.restExecutionService.deleteExecution(executionId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/executions/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="execution-step[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDtoForExecution>>> findExecutionsIssues(@PathVariable(value="id") long id, Pageable pageable) {
        Execution execution = this.restExecutionService.getOne(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(Collections.singletonList(execution.getId()), pageable);
        Page pagedIssueForExecution = pagedIssue.map(this::convertToIssueDtoForExecution);
        for (IssueDtoForExecution issue : pagedIssueForExecution.getContent()) {
            List<ExecutionStep> executionSteps = this.restExecutionStepService.getExecutionStepFromIssue(issue.getRemoteIssueId(), id);
            issue.setExecutionSteps(new HashSet<ExecutionStep>(executionSteps));
        }
        PagedModel res = this.pageAssembler.toModel(pagedIssueForExecution);
        return ResponseEntity.ok((Object)res);
    }

    private IssueDtoForExecution convertToIssueDtoForExecution(IssueDto issueDto) {
        return new IssueDtoForExecution(issueDto.getRemoteIssueId(), issueDto.getUrl());
    }
}

