/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.RestActionWordDto;
import org.squashtest.tm.plugin.rest.service.RestActionWordService;
import org.squashtest.tm.plugin.rest.validators.ActionWordPatchValidator;
import org.squashtest.tm.plugin.rest.validators.ActionWordPostValidator;
import org.squashtest.tm.plugin.rest.validators.EntityValidator;

@UseDefaultRestApiConfiguration
@RestApiController(value=ActionWord.class)
public class RestActionWordController
extends BaseRestController {
    private static final String PATCH_ACTION_WORD = "patch-action-word";
    private static final String POST_ACTION_WORD = "post-action-word";
    @Inject
    private RestActionWordService restActionWordService;
    @Inject
    private ActionWordPatchValidator actionWordPatchValidator;
    @Inject
    private ActionWordPostValidator actionWordPostValidator;

    @EntityGetter
    @DynamicFilterExpression(value="*, project[name], parameters[name, default_value], test_cases[reference, name, importance, status]")
    @GetMapping(value={"/action-words/{id}"})
    public ResponseEntity<EntityModel<ActionWord>> getActionWord(@PathVariable(value="id") long id) {
        ActionWord actionWord = this.restActionWordService.getOne(id);
        EntityModel resource = this.toEntityModel((Identified)actionWord);
        this.addAllLinksForActionWord((EntityModel<ActionWord>)resource);
        return ResponseEntity.ok((Object)resource);
    }

    @DynamicFilterExpression(value="word")
    @GetMapping(value={"/action-words"})
    public ResponseEntity<PagedModel<EntityModel<ActionWord>>> getAllReadableActionWords(Pageable pageable) {
        Page<ActionWord> actionWords = this.restActionWordService.findAllReadableActionWords(pageable);
        PagedModel res = this.toPagedModel(actionWords);
        return ResponseEntity.ok((Object)res);
    }

    @DynamicFilterExpression(value="*, project[name], parameters[name, default_value], test_cases[reference, name, importance, status]")
    @PatchMapping(value={"/action-words/{id}"})
    public ResponseEntity<EntityModel<ActionWord>> patchActionWord(@PathVariable(value="id") long id, @RequestBody RestActionWordDto patch) throws BindException {
        patch.setId(id);
        this.validateSourceDto(patch, this.actionWordPatchValidator, PATCH_ACTION_WORD);
        ActionWord actionWord = this.restActionWordService.patchActionWord(id, patch);
        EntityModel res = this.toEntityModel((Identified)actionWord);
        this.addAllLinksForActionWord((EntityModel<ActionWord>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DynamicFilterExpression(value="*, project[name], parameters[name, default_value], -last_modified_by, -last_modified_on, -last_implementation_technology, -last_implementation_date,-test_cases")
    @PostMapping(value={"/action-words"})
    public ResponseEntity<EntityModel<ActionWord>> postActionWord(@RequestBody RestActionWordDto post) throws BindException {
        this.validateSourceDto(post, this.actionWordPostValidator, POST_ACTION_WORD);
        ActionWord actionWord = this.restActionWordService.createActionWord(post);
        EntityModel res = this.toEntityModel((Identified)actionWord);
        this.addAllLinksForActionWord((EntityModel<ActionWord>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    private void validateSourceDto(RestActionWordDto actionWordDto, EntityValidator validatorService, String validationName) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validationLog = new BeanPropertyBindingResult((Object)actionWordDto, validationName);
        validatorService.validate(actionWordDto, (Errors)validationLog);
        if (validationLog.hasErrors()) {
            errors.add((Errors)validationLog);
        }
        ErrorHandlerHelper.throwIfError(actionWordDto, errors, validationName);
    }

    @DeleteMapping(value={"/action-words/{ids}"})
    public ResponseEntity<String> deleteActionWord(@PathVariable(value="ids") List<Long> ids) {
        List<Long> notDeleteActionWordIds = this.restActionWordService.deleteActionWordsByIds(ids);
        if (notDeleteActionWordIds.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)this.generateNotDeletedActionWordsMessage(notDeleteActionWordIds));
    }

    private String generateNotDeletedActionWordsMessage(List<Long> actionWordIdsUsedInKeywordTestSteps) {
        StringBuilder builder = new StringBuilder("The action words with the following identifiers were not deleted because they are used in at least one test step: ");
        for (Long actionWordId : actionWordIdsUsedInKeywordTestSteps) {
            builder.append(actionWordId).append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    @DynamicFilterExpression(value="word")
    @GetMapping(value={"/projects/{id}/action-words"})
    public ResponseEntity<PagedModel<EntityModel<ActionWord>>> getAllActionWordsByProject(@PathVariable(value="id") long projectId, Pageable pageable) {
        Page<ActionWord> actionWords = this.restActionWordService.findAllActionWordsByProject(projectId, pageable);
        PagedModel res = this.toPagedModel(actionWords);
        return ResponseEntity.ok((Object)res);
    }

    private void addAllLinksForActionWord(EntityModel<ActionWord> resource) {
        ActionWord actionWord = (ActionWord)resource.getContent();
        if (actionWord != null) {
            resource.add(this.linkService.createLinkTo((Identified)actionWord.getProject()));
        }
    }
}

