-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-dm8vx5ae (100.64.7.5)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-13.0.0.xml
-- Ran at: 16/02/2026 15:28
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.31.1
-- *********************************************************************

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-migrate-default-admin-password-to-bcrypt::jprioux
UPDATE AUTH_USER SET PASSWORD = '{bcrypt}$2a$10$fr03fOEa6cGQAmJ3wankJu9hH9PZeJ/Jqjd3yVWEJ4zBIeNMxQrRa' WHERE LOGIN = 'admin' AND PASSWORD = 'd033e22ae348aeb5660fc2140aec35850c4da997';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-migrate-default-admin-password-to-bcrypt', 'jprioux', 'tm/tm.changelog-13.0.0.xml', NOW(), 1, '9:9ece7c141a3ae3645da14b938b61ef53', 'update tableName=AUTH_USER', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-rename-ai_usage-table::mbrugniere
ALTER TABLE AI_USAGE RENAME TO AI_USE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-rename-ai_usage-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 2, '9:98b91dbf49c67753ae4329aa07560555', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-drop-fk-project_ai_configuration_ai_usage::mbrugniere
ALTER TABLE PROJECT_AI_CONFIGURATION DROP CONSTRAINT fk_project_ai_configuration_ai_usage;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-drop-fk-project_ai_configuration_ai_usage', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 3, '9:c77a4e9a89cc966928d4e1adc83c7d4e', 'dropForeignKeyConstraint baseTableName=PROJECT_AI_CONFIGURATION, constraintName=fk_project_ai_configuration_ai_usage', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-drop-fk-prompt_set_ai_usage::mbrugniere
ALTER TABLE PROMPT_SET DROP CONSTRAINT fk_prompt_set_ai_usage;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-drop-fk-prompt_set_ai_usage', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 4, '9:3790bfb40fd4b2ef67d49c25f675d00a', 'dropForeignKeyConstraint baseTableName=PROMPT_SET, constraintName=fk_prompt_set_ai_usage', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-drop-uq-project_ai_configuration_ai_usage_id::mbrugniere
ALTER TABLE PROJECT_AI_CONFIGURATION DROP CONSTRAINT uq_project_ai_configuration_project_id_ai_usage_id;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-drop-uq-project_ai_configuration_ai_usage_id', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 5, '9:91028483007bc3cd1ec4082ae77cfaff', 'dropUniqueConstraint constraintName=uq_project_ai_configuration_project_id_ai_usage_id, tableName=PROJECT_AI_CONFIGURATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-drop-pk_ai_usage::mbrugniere
ALTER TABLE AI_USE DROP CONSTRAINT pk_ai_usage;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-drop-pk_ai_usage', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 6, '9:adb2085d885fffb52ed4b8e4d2b370a8', 'dropPrimaryKey constraintName=pk_ai_usage, tableName=AI_USE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-rename-ai_usage_id-column-in-ai_use-table::mbrugniere
ALTER TABLE AI_USE RENAME COLUMN AI_USAGE_ID TO AI_USE_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-rename-ai_usage_id-column-in-ai_use-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 7, '9:a7a31baf38f4e10fc016e6f5a6331e33', 'renameColumn newColumnName=AI_USE_ID, oldColumnName=AI_USAGE_ID, tableName=AI_USE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-primary-key-pk_ai_use::mbrugniere
ALTER TABLE AI_USE ADD CONSTRAINT pk_ai_use PRIMARY KEY (AI_USE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-primary-key-pk_ai_use', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 8, '9:0d023145c18fa32ab2af7b4c762affd7', 'addPrimaryKey constraintName=pk_ai_use, tableName=AI_USE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-rename-usage-column-in-ai_use-table::mbrugniere
ALTER TABLE AI_USE RENAME COLUMN USAGE TO USE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-rename-usage-column-in-ai_use-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 9, '9:55e37befeb6d61f391d2b521a84c6f74', 'renameColumn newColumnName=USE, oldColumnName=USAGE, tableName=AI_USE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-rename-sequence-ai_usage_ai_usage_id_seq-to-ai_use_ai_use_id_seq-postgresql::mbrugniere
ALTER SEQUENCE IF EXISTS ai_usage_ai_usage_id_seq RENAME TO ai_use_ai_use_id_seq;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-rename-sequence-ai_usage_ai_usage_id_seq-to-ai_use_ai_use_id_seq-postgresql', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 10, '9:65d49ea8fb77a51f0225e862a7071a54', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-drop-unique-key-ai_usage-in-ai_use_table::mbrugniere
ALTER TABLE AI_USE DROP CONSTRAINT uq_ai_usage_usage;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-drop-unique-key-ai_usage-in-ai_use_table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 11, '9:23aee4dfca4bb23835a5ef2b469e1faa', 'dropUniqueConstraint constraintName=uq_ai_usage_usage, tableName=AI_USE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-unique-key-in-ai_use-table::mbrugniere
ALTER TABLE AI_USE ADD CONSTRAINT uq_ai_use_use UNIQUE (USE);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-unique-key-in-ai_use-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 12, '9:6cda3b2185f4ed9260551f5d33a3c5bc', 'addUniqueConstraint constraintName=uq_ai_use_use, tableName=AI_USE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-rename-ai_usage-for-ai_use-in-project_ai_configuration-table::mbrugniere
ALTER TABLE PROJECT_AI_CONFIGURATION RENAME COLUMN AI_USAGE_ID TO AI_USE_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-rename-ai_usage-for-ai_use-in-project_ai_configuration-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 13, '9:86deb54bdbf2e78f7d01e7c135375f15', 'renameColumn newColumnName=AI_USE_ID, oldColumnName=AI_USAGE_ID, tableName=PROJECT_AI_CONFIGURATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-create-index-for-ai_use_id-in-project_ai_configuration-table::mbrugniere
CREATE INDEX idx_project_ai_configuration_ai_use_id ON PROJECT_AI_CONFIGURATION(AI_USE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-create-index-for-ai_use_id-in-project_ai_configuration-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 14, '9:5af69583b884a1765d998d188af90a70', 'createIndex indexName=idx_project_ai_configuration_ai_use_id, tableName=PROJECT_AI_CONFIGURATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-drop-index-in-project_ai_configuration-table::mbrugniere
DROP INDEX idx_project_ai_configuration_ai_usage_id;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-drop-index-in-project_ai_configuration-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 15, '9:deec90e150205afd45231e8795476d04', 'dropIndex indexName=idx_project_ai_configuration_ai_usage_id, tableName=PROJECT_AI_CONFIGURATION', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-keys-in-project_ai_configuration-table::mbrugniere
ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT uq_project_ai_configuration_project_id_ai_use_id UNIQUE (PROJECT_ID, AI_USE_ID);

ALTER TABLE PROJECT_AI_CONFIGURATION ADD CONSTRAINT fk_project_ai_configuration_ai_use FOREIGN KEY (AI_USE_ID) REFERENCES AI_USE (AI_USE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-keys-in-project_ai_configuration-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 16, '9:a0162e70f4bb640e6263329da319f41e', 'addUniqueConstraint constraintName=uq_project_ai_configuration_project_id_ai_use_id, tableName=PROJECT_AI_CONFIGURATION; addForeignKeyConstraint baseTableName=PROJECT_AI_CONFIGURATION, constraintName=fk_project_ai_configuration_ai_use, referencedT...', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-rename-ai_usage-for-ai_use-in-prompt_set-table::mbrugniere
ALTER TABLE PROMPT_SET RENAME COLUMN AI_USAGE_ID TO AI_USE_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-rename-ai_usage-for-ai_use-in-prompt_set-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 17, '9:7d1f9384cb4651b61bad453b52951637', 'renameColumn newColumnName=AI_USE_ID, oldColumnName=AI_USAGE_ID, tableName=PROMPT_SET', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-create-index-for_ai_use_id_in-prompt_set-table::mbrugniere
CREATE INDEX idx_prompt_set_ai_use_id ON PROMPT_SET(AI_USE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-create-index-for_ai_use_id_in-prompt_set-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 18, '9:f6d6cbd05ac6951b7bde743b316e7c36', 'createIndex indexName=idx_prompt_set_ai_use_id, tableName=PROMPT_SET', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-drop-index-in-prompt_set-table::mbrugniere
DROP INDEX idx_prompt_set_ai_usage_id;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-drop-index-in-prompt_set-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 19, '9:9c7ccf6c19b0fa1c2d6d600ad8fdb1d3', 'dropIndex indexName=idx_prompt_set_ai_usage_id, tableName=PROMPT_SET', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-foreign-key-in-prompt_set-table::mbrugniere
ALTER TABLE PROMPT_SET ADD CONSTRAINT fk_prompt_set_ai_use FOREIGN KEY (AI_USE_ID) REFERENCES AI_USE (AI_USE_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-foreign-key-in-prompt_set-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 20, '9:c075b45a5369a44c5f637c56ae488950', 'addForeignKeyConstraint baseTableName=PROMPT_SET, constraintName=fk_prompt_set_ai_use, referencedTableName=AI_USE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-create-index-idx_fk_prompt_prompt_set::mbrugniere
CREATE INDEX idx_fk_prompt_prompt_set_id ON PROMPT(PROMPT_SET_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-create-index-idx_fk_prompt_prompt_set', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 21, '9:ba5dce268035b8667c760574c1e11098', 'createIndex indexName=idx_fk_prompt_prompt_set_id, tableName=PROMPT', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-create-quick-test-table-postgresql::jpmarque
-- Create quick test table
CREATE TABLE QUICK_TEST (QUICK_TEST_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, SPRINT_REQ_VERSION_ID BIGINT NOT NULL, ATTACHMENT_LIST_ID BIGINT, ISSUE_LIST_ID BIGINT, NAME VARCHAR(255) NOT NULL, EXECUTION_STATUS VARCHAR(50) NOT NULL, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON TIMESTAMP WITHOUT TIME ZONE NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null, LAST_MODIFIED_ON TIMESTAMP WITHOUT TIME ZONE DEFAULT null, CONSTRAINT pk_quick_test PRIMARY KEY (QUICK_TEST_ID), CONSTRAINT fk_quick_test_attachment_list FOREIGN KEY (ATTACHMENT_LIST_ID) REFERENCES ATTACHMENT_LIST(ATTACHMENT_LIST_ID), CONSTRAINT fk_quick_test_issue_list FOREIGN KEY (ISSUE_LIST_ID) REFERENCES ISSUE_LIST(ISSUE_LIST_ID), CONSTRAINT fk_quick_test_sprint_req_version FOREIGN KEY (SPRINT_REQ_VERSION_ID) REFERENCES SPRINT_REQ_VERSION(SPRINT_REQ_VERSION_ID));

COMMENT ON COLUMN QUICK_TEST.SPRINT_REQ_VERSION_ID IS 'fk to sprint req version';

COMMENT ON COLUMN QUICK_TEST.ATTACHMENT_LIST_ID IS 'Foreign key to attachment list';

COMMENT ON COLUMN QUICK_TEST.ISSUE_LIST_ID IS 'Foreign key to issue list';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-create-quick-test-table-postgresql', 'jpmarque', 'tm/tm.changelog-13.0.0.xml', NOW(), 22, '9:753a2d7c37b50b3f1b5b4c5378375652', 'createTable tableName=QUICK_TEST', 'Create quick test table', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-create-indexes-for-quick-test-table::jpmarque
CREATE INDEX idx_quick_test_issue_list_id ON QUICK_TEST(ISSUE_LIST_ID);

CREATE INDEX idx_quick_test_attachment_list_id ON QUICK_TEST(ATTACHMENT_LIST_ID);

CREATE INDEX idx_quick_test_sprint_req_version_id ON QUICK_TEST(SPRINT_REQ_VERSION_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-create-indexes-for-quick-test-table', 'jpmarque', 'tm/tm.changelog-13.0.0.xml', NOW(), 23, '9:22576ac194d130cb5c7b79cb75a8eb43', 'createIndex indexName=idx_quick_test_issue_list_id, tableName=QUICK_TEST; createIndex indexName=idx_quick_test_attachment_list_id, tableName=QUICK_TEST; createIndex indexName=idx_quick_test_sprint_req_version_id, tableName=QUICK_TEST', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-create-quick-test-note-table-postgresql::jpmarque
-- Create  quick test note table
CREATE TABLE QUICK_TEST_NOTE (QUICK_TEST_NOTE_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, QUICK_TEST_ID BIGINT NOT NULL, CONTENT TEXT DEFAULT null, CONSTRAINT pk_quick_test_note PRIMARY KEY (QUICK_TEST_NOTE_ID), CONSTRAINT fk_quick_test_note_quick_test FOREIGN KEY (QUICK_TEST_ID) REFERENCES QUICK_TEST(QUICK_TEST_ID));

COMMENT ON COLUMN QUICK_TEST_NOTE.QUICK_TEST_ID IS 'fk to the parent quick test';

COMMENT ON COLUMN QUICK_TEST_NOTE.CONTENT IS 'Rich text for a quick test';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-create-quick-test-note-table-postgresql', 'jpmarque', 'tm/tm.changelog-13.0.0.xml', NOW(), 24, '9:7e507c230fca7f7d20fbda022f70f978', 'createTable tableName=QUICK_TEST_NOTE', 'Create  quick test note table', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-create-indexes-for-quick-test-note-table::jpmarque
CREATE INDEX idx_quick_test_note_quick_test_id ON QUICK_TEST_NOTE(QUICK_TEST_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-create-indexes-for-quick-test-note-table', 'jpmarque', 'tm/tm.changelog-13.0.0.xml', NOW(), 25, '9:a033ea34f0a22a1826a2d9d3d755d1fe', 'createIndex indexName=idx_quick_test_note_quick_test_id, tableName=QUICK_TEST_NOTE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-column-ai_prompt_language-in-project-table::mbrugniere
ALTER TABLE PROJECT ADD AI_PROMPT_LANGUAGE VARCHAR(30) DEFAULT 'ENGLISH' NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-column-ai_prompt_language-in-project-table', 'mbrugniere', 'tm/tm.changelog-13.0.0.xml', NOW(), 26, '9:a8ab650b9a265a84ebc9664052556a98', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-tc-library-node-soft-delete-column::bmsaddek
ALTER TABLE TEST_CASE_LIBRARY_NODE ADD DELETED_BY VARCHAR(100) DEFAULT null;

ALTER TABLE TEST_CASE_LIBRARY_NODE ADD DELETED_ON TIMESTAMP WITHOUT TIME ZONE DEFAULT null;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-tc-library-node-soft-delete-column', 'bmsaddek', 'tm/tm.changelog-13.0.0.xml', NOW(), 27, '9:132516b46db02816613790c0ad1a558a', 'addColumn tableName=TEST_CASE_LIBRARY_NODE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-test-plan-item-deleted-column::bmsaddek
ALTER TABLE TEST_PLAN_ITEM ADD DELETED BOOLEAN DEFAULT FALSE NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-test-plan-item-deleted-column', 'bmsaddek', 'tm/tm.changelog-13.0.0.xml', NOW(), 28, '9:0af7de00bfc886ad0722fb5064e841da', 'addColumn tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-test-case-soft-delete-indexes-postgres::bmsaddek
CREATE INDEX IF NOT EXISTS idx_test_case_library_node_not_deleted
        ON TEST_CASE_LIBRARY_NODE(tcln_id)
        WHERE deleted_on IS NULL;

CREATE INDEX IF NOT EXISTS idx_test_case_library_node_deleted
        ON TEST_CASE_LIBRARY_NODE(tcln_id)
        WHERE deleted_on IS NOT NULL;

ANALYZE TEST_CASE_LIBRARY_NODE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-test-case-soft-delete-indexes-postgres', 'bmsaddek', 'tm/tm.changelog-13.0.0.xml', NOW(), 29, '9:107e6b2cccd96e2c98d980a94435b4ca', 'sql; sql; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-test-plan-item-soft-delete-indexes::bmsaddek
CREATE INDEX idx_test_plan_item_deleted_test_plan_item_id ON TEST_PLAN_ITEM(DELETED, TEST_PLAN_ITEM_ID);

ANALYZE TEST_PLAN_ITEM;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-test-plan-item-soft-delete-indexes', 'bmsaddek', 'tm/tm.changelog-13.0.0.xml', NOW(), 30, '9:c97873864e99dc61451497d5d60aa122', 'createIndex indexName=idx_test_plan_item_deleted_test_plan_item_id, tableName=TEST_PLAN_ITEM; sql; sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-deletion-threshold-in-core-config::llecrocq
INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('squash.control.deletion.threshold', '0');

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-deletion-threshold-in-core-config', 'llecrocq', 'tm/tm.changelog-13.0.0.xml', NOW(), 31, '9:381fa1d8c5dd92bddfb5a5c378f10cec', 'insert tableName=CORE_CONFIG', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-add-lifecycle-completed-column-automated-execution-extender::fahadi
-- Add lifecycle tracking column to AUTOMATED_EXECUTION_EXTENDER for retry tracking
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD LIFECYCLE_COMPLETED BOOLEAN DEFAULT FALSE NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-add-lifecycle-completed-column-automated-execution-extender', 'fahadi', 'tm/tm.changelog-13.0.0.xml', NOW(), 32, '9:ab35db1ad08be8adbc9e8a22c28ac1e8', 'addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', 'Add lifecycle tracking column to AUTOMATED_EXECUTION_EXTENDER for retry tracking', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-set-existing-executions-lifecycle-completed-to-true::fahadi
-- Mark all existing automated executions as lifecycle completed
UPDATE AUTOMATED_EXECUTION_EXTENDER SET LIFECYCLE_COMPLETED = TRUE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-set-existing-executions-lifecycle-completed-to-true', 'fahadi', 'tm/tm.changelog-13.0.0.xml', NOW(), 33, '9:9fef104dfd84cd9531b68d75b3f2c085', 'update tableName=AUTOMATED_EXECUTION_EXTENDER', 'Mark all existing automated executions as lifecycle completed', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0-modify-custom-field-large-value-to-longtext::bmsaddek
ALTER TABLE CUSTOM_FIELD ALTER COLUMN LARGE_DEFAULT_VALUE TYPE TEXT USING (LARGE_DEFAULT_VALUE::TEXT);

ALTER TABLE CUSTOM_FIELD_VALUE ALTER COLUMN LARGE_VALUE TYPE TEXT USING (LARGE_VALUE::TEXT);

ALTER TABLE DENORMALIZED_FIELD_VALUE ALTER COLUMN LARGE_VALUE TYPE TEXT USING (LARGE_VALUE::TEXT);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0-modify-custom-field-large-value-to-longtext', 'bmsaddek', 'tm/tm.changelog-13.0.0.xml', NOW(), 34, '9:713e3c84d60e8aa87c148f51b8a0b650', 'modifyDataType columnName=LARGE_DEFAULT_VALUE, tableName=CUSTOM_FIELD; modifyDataType columnName=LARGE_VALUE, tableName=CUSTOM_FIELD_VALUE; modifyDataType columnName=LARGE_VALUE, tableName=DENORMALIZED_FIELD_VALUE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Changeset tm/tm.changelog-13.0.0.xml::tm-13.0.0::jprioux
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '13.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-13.0.0', 'jprioux', 'tm/tm.changelog-13.0.0.xml', NOW(), 35, '9:b47605cf2742e9bfb62dcc7cd795ab44', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

