--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-dm8vx5ae (100.64.7.5)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-11.0.0.xml
--  Ran at: 16/02/2026 15:28
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.31.1
--  *********************************************************************

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-drop-denormalized-field-rendering-location-table::rfortoso
--  DENORMALIZED_FIELD_RENDERING_LOCATION has been unused for some time
TRUNCATE TABLE DENORMALIZED_FIELD_RENDERING_LOCATION;

DROP TABLE DENORMALIZED_FIELD_RENDERING_LOCATION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-drop-denormalized-field-rendering-location-table', 'rfortoso', 'tm/tm.changelog-11.0.0.xml', NOW(), 1, '9:2134953219c7d382fd79326dcb60702e', 'sql', 'DENORMALIZED_FIELD_RENDERING_LOCATION has been unused for some time', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-drop-custom_field_rendering_location-table::rfortoso
--  CUSTOM_FIELD_RENDERING_LOCATION has been unused for some time
TRUNCATE TABLE CUSTOM_FIELD_RENDERING_LOCATION;

DROP TABLE CUSTOM_FIELD_RENDERING_LOCATION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-drop-custom_field_rendering_location-table', 'rfortoso', 'tm/tm.changelog-11.0.0.xml', NOW(), 2, '9:9525391553b3e77979b812c536cb1c5d', 'sql', 'CUSTOM_FIELD_RENDERING_LOCATION has been unused for some time', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-rename-test-automation-server-user-for-technical-account::mbrugniere
--  Rename the user group "Test Automation Server" to "Technical Account"
UPDATE CORE_GROUP SET QUALIFIED_NAME = 'squashtest.authz.group.tm.TechnicalAccount' WHERE qualified_name = 'squashtest.authz.group.tm.TestAutomationServer';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-rename-test-automation-server-user-for-technical-account', 'mbrugniere', 'tm/tm.changelog-11.0.0.xml', NOW(), 3, '9:f4a59cb47e80849c787979faff10f59e', 'update tableName=CORE_GROUP', 'Rename the user group "Test Automation Server" to "Technical Account"', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-sequence-for-test-automation-candidate-mariadb::fahadi
CREATE SEQUENCE IF NOT EXISTS test_automation_candidate_test_automation_candidate_id_seq START WITH 1 INCREMENT BY 30 CACHE 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-sequence-for-test-automation-candidate-mariadb', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 4, '9:deb10f312d6b3df48442f102335ae1b4', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-create-test-automation-candidate-table-h2::fahadi
CREATE TABLE TEST_AUTOMATION_CANDIDATE (TEST_AUTOMATION_CANDIDATE_ID BIGINT DEFAULT NEXT VALUE FOR test_automation_candidate_test_automation_candidate_id_seq NOT NULL, TEST_CASE_ID BIGINT NOT NULL, PRIORITY_SCORE INT NOT NULL, EVALUATED_ON datetime NOT NULL, EVALUATED_BY VARCHAR(100) NOT NULL, SUGGESTION_STATUS VARCHAR(50) NOT NULL, DECIDED_ON datetime NULL, DECIDED_BY VARCHAR(100) NULL, CONSTRAINT pk_test_automation_candidate PRIMARY KEY (TEST_AUTOMATION_CANDIDATE_ID), CONSTRAINT uq_test_automation_candidate_test_case_id UNIQUE (TEST_CASE_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-create-test-automation-candidate-table-h2', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 5, '9:2c026bbf659d18ccb66c56fa7e177875', 'createTable tableName=TEST_AUTOMATION_CANDIDATE', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-test-automation-candidate-indexes-and-fk::fahadi
CREATE INDEX idx_test_automation_candidate_test_case_id ON TEST_AUTOMATION_CANDIDATE(TEST_CASE_ID);

CREATE INDEX idx_test_automation_candidate_suggestion_status ON TEST_AUTOMATION_CANDIDATE(SUGGESTION_STATUS);

ALTER TABLE TEST_AUTOMATION_CANDIDATE ADD CONSTRAINT fk_test_automation_candidate_test_case FOREIGN KEY (TEST_CASE_ID) REFERENCES TEST_CASE (TCLN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-test-automation-candidate-indexes-and-fk', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 6, '9:355247452771947ff8243aba64793d8c', 'createIndex indexName=idx_test_automation_candidate_test_case_id, tableName=TEST_AUTOMATION_CANDIDATE; createIndex indexName=idx_test_automation_candidate_suggestion_status, tableName=TEST_AUTOMATION_CANDIDATE; addForeignKeyConstraint baseTableNam...', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-remove-allowEdit-from-library-plugin-binding-property-h2::lmurat
UPDATE LIBRARY_PLUGIN_BINDING_PROPERTY
      SET PLUGIN_BINDING_VALUE = REPLACE(REPLACE(
                                           REPLACE(REPLACE(
                                                     PLUGIN_BINDING_VALUE,
                                                     ',"allowEdit":false', ''),
                                                   ',"allowEdit":true', ''),
                                           '"allowEdit":false,', ''),
                                         '"allowEdit":true,', ''
                                 )
      WHERE PLUGIN_BINDING_KEY = 'attributeMappings' AND PLUGIN_BINDING_VALUE LIKE '%"allowEdit":%';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-remove-allowEdit-from-library-plugin-binding-property-h2', 'lmurat', 'tm/tm.changelog-11.0.0.xml', NOW(), 7, '9:ddc651bf29188a1383c937c4c79d123e', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-automated-test-suite-import-attachment-extension-whitelist::ssviridov
INSERT INTO CORE_CONFIG (STR_KEY, VALUE) VALUES ('uploadfilter.fileExtensions.resultImport.whitelist', 'txt, html, xml, doc');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-automated-test-suite-import-attachment-extension-whitelist', 'ssviridov', 'tm/tm.changelog-11.0.0.xml', NOW(), 8, '9:4c09e13daf679b52373f7a7013f36987', 'insert tableName=CORE_CONFIG', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-multi-campaign-report-campaign-ids-modification::jprioux
UPDATE REPORT_DEFINITION
      SET PARAMETERS = REPLACE(
                         PARAMETERS,
                         '"campaignId":',
                         '"campaignIds":'
                       )
      WHERE PLUGIN_NAMESPACE = 'report.campaignassessment.report.label';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-multi-campaign-report-campaign-ids-modification', 'jprioux', 'tm/tm.changelog-11.0.0.xml', NOW(), 9, '9:49c2173a3ef609a1c23bc4820d8a642b', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-increase-attachment-content-size-mariadb::jpmarque
--  Increase attachment content size
ALTER TABLE ATTACHMENT_CONTENT MODIFY COLUMN STREAM_CONTENT LONGBLOB;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-increase-attachment-content-size-mariadb', 'jpmarque', 'tm/tm.changelog-11.0.0.xml', NOW(), 10, '9:58e611b6ef2af1c6af4685d5be8cf70c', 'sql', 'Increase attachment content size', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-export-permission-to-project-manager-profile::amarjollet
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT (SELECT ID FROM ACL_GROUP WHERE QUALIFIED_NAME = 'squashtest.acl.group.tm.ProjectManager'),
             64,
             (SELECT ID FROM ACL_CLASS WHERE CLASSNAME = 'org.squashtest.tm.domain.project.Project');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-export-permission-to-project-manager-profile', 'amarjollet', 'tm/tm.changelog-11.0.0.xml', NOW(), 11, '9:a745a8b879bc1c5e3adaafa4e63fa112', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-sequence-for-test-automation-candidate-analysis-mariadb::fahadi
CREATE SEQUENCE IF NOT EXISTS test_candidate_analysis_test_candidate_analysis_id_seq START WITH 1 INCREMENT BY 1 CACHE 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-sequence-for-test-automation-candidate-analysis-mariadb', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 12, '9:bbe851a6d95a4bb6c00094a5bcd2392d', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-create-test-candidate-analysis-table-mariadb-h2::fahadi
CREATE TABLE TEST_CANDIDATE_ANALYSIS (TEST_CANDIDATE_ANALYSIS_ID BIGINT DEFAULT NEXT VALUE FOR test_candidate_analysis_test_candidate_analysis_id_seq NOT NULL, STATUS VARCHAR(20) NOT NULL, NB_OF_PROCESSED_TC INT DEFAULT 0 NOT NULL, NB_OF_TOTAL_TC INT NOT NULL, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON datetime NOT NULL, TERMINATED_ON datetime NULL, CONSTRAINT pk_test_candidate_analysis PRIMARY KEY (TEST_CANDIDATE_ANALYSIS_ID));

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-create-test-candidate-analysis-table-mariadb-h2', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 13, '9:452ba0316702acec30dc9bc39c32ff87', 'createTable tableName=TEST_CANDIDATE_ANALYSIS', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-create-test-candidate-analysis-project-table::fahadi
CREATE TABLE TEST_CANDIDATE_ANALYSIS_PROJECT (TEST_CANDIDATE_ANALYSIS_ID BIGINT NOT NULL, PROJECT_ID BIGINT NOT NULL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-create-test-candidate-analysis-project-table', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 14, '9:bddc2ac0e646beb4d681544f8a608f3b', 'createTable tableName=TEST_CANDIDATE_ANALYSIS_PROJECT', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-test-candidate-analysis-project-primary-key::fahadi
ALTER TABLE TEST_CANDIDATE_ANALYSIS_PROJECT ADD PRIMARY KEY (TEST_CANDIDATE_ANALYSIS_ID, PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-test-candidate-analysis-project-primary-key', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 15, '9:5db7f1fac5d0f321d5f98d464e7995fd', 'addPrimaryKey constraintName=pk_test_candidate_analysis_project, tableName=TEST_CANDIDATE_ANALYSIS_PROJECT', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-test-candidate-analysis-foreign-keys::fahadi
ALTER TABLE TEST_CANDIDATE_ANALYSIS_PROJECT ADD CONSTRAINT fk_test_candidate_analysis_project_test_candidate_analysis FOREIGN KEY (TEST_CANDIDATE_ANALYSIS_ID) REFERENCES TEST_CANDIDATE_ANALYSIS (TEST_CANDIDATE_ANALYSIS_ID) ON DELETE CASCADE;

ALTER TABLE TEST_CANDIDATE_ANALYSIS_PROJECT ADD CONSTRAINT fk_test_candidate_analysis_project_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-test-candidate-analysis-foreign-keys', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 16, '9:05d6d38c15c2ad43231b1c483b8ba8ae', 'addForeignKeyConstraint baseTableName=TEST_CANDIDATE_ANALYSIS_PROJECT, constraintName=fk_test_candidate_analysis_project_test_candidate_analysis, referencedTableName=TEST_CANDIDATE_ANALYSIS; addForeignKeyConstraint baseTableName=TEST_CANDIDATE_ANA...', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-test-candidate-analysis-indexes::fahadi
CREATE INDEX idx_test_candidate_analysis_status ON TEST_CANDIDATE_ANALYSIS(STATUS);

CREATE INDEX idx_test_candidate_analysis_created_by ON TEST_CANDIDATE_ANALYSIS(CREATED_BY);

CREATE INDEX idx_test_candidate_analysis_created_on ON TEST_CANDIDATE_ANALYSIS(CREATED_ON);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-test-candidate-analysis-indexes', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 17, '9:d8225d5a24adcb4fbc280f4194ee6430', 'createIndex indexName=idx_test_candidate_analysis_status, tableName=TEST_CANDIDATE_ANALYSIS; createIndex indexName=idx_test_candidate_analysis_created_by, tableName=TEST_CANDIDATE_ANALYSIS; createIndex indexName=idx_test_candidate_analysis_created...', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-test-candidate-analysis-project-indexes::fahadi
CREATE INDEX idx_test_candidate_analysis_project_project_id ON TEST_CANDIDATE_ANALYSIS_PROJECT(PROJECT_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-test-candidate-analysis-project-indexes', 'fahadi', 'tm/tm.changelog-11.0.0.xml', NOW(), 18, '9:764c729c6715f1c172f50863fa8abbcc', 'createIndex indexName=idx_test_candidate_analysis_project_project_id, tableName=TEST_CANDIDATE_ANALYSIS_PROJECT', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-query-column-prototypes::bmarejus
INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, LABEL, ENTITY_TYPE, ENTITY_ROLE, ATTRIBUTE_NAME, DATA_TYPE,
                                          BUSINESS)
      SELECT 'ATTRIBUTE', 'TEST_PLAN_ID', 'TEST_PLAN', null, 'id', 'NUMERIC', false
      WHERE NOT EXISTS (
          SELECT 1
          FROM QUERY_COLUMN_PROTOTYPE
          WHERE LABEL = 'TEST_PLAN_ID' AND ATTRIBUTE_NAME = 'id'
      );

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, LABEL, ENTITY_TYPE, ENTITY_ROLE, ATTRIBUTE_NAME, DATA_TYPE,
                                          BUSINESS)
      SELECT 'ATTRIBUTE', 'CAMPAIGN_LIBRARY_ID', 'CAMPAIGN_LIBRARY', null, 'id', 'NUMERIC', false
      WHERE NOT EXISTS (
          SELECT 1
          FROM QUERY_COLUMN_PROTOTYPE
          WHERE LABEL = 'CAMPAIGN_LIBRARY_ID' AND ATTRIBUTE_NAME = 'id'
      );

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, LABEL, ENTITY_TYPE, ENTITY_ROLE, ATTRIBUTE_NAME, DATA_TYPE,
                                          BUSINESS)
      SELECT 'ATTRIBUTE', 'SPRINT_ID', 'SPRINT', null, 'id', 'NUMERIC', false
      WHERE NOT EXISTS (
          SELECT 1
          FROM QUERY_COLUMN_PROTOTYPE
          WHERE LABEL = 'SPRINT_ID' AND ATTRIBUTE_NAME = 'id'
      );

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, LABEL, ENTITY_TYPE, ENTITY_ROLE, ATTRIBUTE_NAME, DATA_TYPE,
                                          BUSINESS)
      SELECT 'ATTRIBUTE', 'SPRINT_NAME', 'SPRINT', null, 'name', 'STRING', false
      WHERE NOT EXISTS (
          SELECT 1
          FROM QUERY_COLUMN_PROTOTYPE
          WHERE LABEL = 'SPRINT_NAME' AND ATTRIBUTE_NAME = 'name'
      );

INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, LABEL, ENTITY_TYPE, ENTITY_ROLE, ATTRIBUTE_NAME, DATA_TYPE,
                                          BUSINESS)
      SELECT 'ATTRIBUTE', 'CAMPAIGN_LIBRARY_PROJECT_NAME', 'PROJECT', 'CAMPAIGN_LIBRARY_PROJECT', 'name', 'STRING', false
      WHERE NOT EXISTS (
          SELECT 1
          FROM QUERY_COLUMN_PROTOTYPE
          WHERE LABEL = 'CAMPAIGN_LIBRARY_PROJECT_NAME' AND ATTRIBUTE_NAME = 'name'
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-query-column-prototypes', 'bmarejus', 'tm/tm.changelog-11.0.0.xml', NOW(), 19, '9:3dea6b9476c5ea192511f624db66fab6', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-add-decided-priority-column-to-test-automation-candidate::xzhao
--  Add new DECIDED_PRIORITY column to TEST_AUTOMATION_CANDIDATE table
ALTER TABLE TEST_AUTOMATION_CANDIDATE ADD DECIDED_PRIORITY INT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-add-decided-priority-column-to-test-automation-candidate', 'xzhao', 'tm/tm.changelog-11.0.0.xml', NOW(), 20, '9:2726dde7069306f4dc5e8a24a299ff71', 'addColumn tableName=TEST_AUTOMATION_CANDIDATE', 'Add new DECIDED_PRIORITY column to TEST_AUTOMATION_CANDIDATE table', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0-multi-iteration-report-iteration-ids-modification::jprioux
UPDATE REPORT_DEFINITION
      SET PARAMETERS = REPLACE(
                        PARAMETERS,
                        '"iterationId":',
                        '"iterationIds":'
                       )
      WHERE PLUGIN_NAMESPACE = 'report.iteration.report.label';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0-multi-iteration-report-iteration-ids-modification', 'jprioux', 'tm/tm.changelog-11.0.0.xml', NOW(), 21, '9:9acdbca6922cb5ac63ed7e2940071649', 'sql', '', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Changeset tm/tm.changelog-11.0.0.xml::tm-11.0.0::pckerneis
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '11.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-11.0.0', 'pckerneis', 'tm/tm.changelog-11.0.0.xml', NOW(), 22, '9:3ed30322891a529c8a8f22201d0dee37', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.31.1', '1252098429');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

