/*
 *     This file is part of the Campaign Assistant for Squash TM (henix-tm-wizard-campaignassistant) project.
 *     Copyright (C) 2017 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
define(["jquery", "workspace.routing", "backbone", "underscore", "handlebars", "squash.translator", "./abstractStepView", "squashtable"],
	function($, router, backbone, _, Handlebars, msg, AbstractStepView) {
	"use strict";

	var previewStepView = AbstractStepView.extend({

		initialize : function(data, wizrouter) {
			this.tmpl = "#preview-step-tpl";
			this.model = data;
			data.name = "previewStep";
			this._initialize(data, wizrouter);
		},

		prepareUI: function() {

            this.initPreviewTable();
		},

		reloadDataInView: function() {},

		updateModel : function() {},

        initPreviewTable: function() {

            var self = this;

            var table = self.getPreviewTable();
            var testPlan = self.model.get("testPlan");

            table.squashTable({
                aaData: testPlan,
                bServerSide: false
            },
            {
                buttons: [{
                    tooltip: msg.get('campaignassistant.wizard.previewStep.table.deleteButton.tooltip'),
                    tdSelector: 'td.unbind-or-delete',
                    uiIcon: "ui-icon-minus",
                    jquery: true,
                    onClick: function(table, cell) {
                        self.onRemoveBtnClick(self, table, cell);
                    }
                }]
            });
        },

        onRemoveBtnClick: function(self, table, cell) {
            var row = cell.parentNode.parentNode;
            var itpiId = table.getODataId(row);
            var testPlan = self.model.get('testPlan');
            var indexToRemove = _.findIndex(testPlan, function(itpi) {
                return itpi['itpi-id'] === itpiId;
            });
            testPlan.splice(indexToRemove, 1);
            self._adjustTestPlanIndexes(testPlan, indexToRemove);
            self.model.set({
                testPlan: testPlan
            });
            self.refreshPreviewTable();
        },

        _adjustTestPlanIndexes: function(testPlan, removedIndex) {
            for(var i=removedIndex; i<testPlan.length-1; i++) {
                testPlan[i]['itpi-index']--;
            }
        },

        getPreviewTable: function() {

            return this.$el.find("#replicated-test-plan-table");
        },

        refreshPreviewTable: function() {
            var data = this.model.get('testPlan');
            var table = this.getPreviewTable().squashTable();

            table.fnClearTable();
            if(data.length !== 0) {
                table.fnAddData(data);
            }
        },

        _loadPreviewTestPlan: function() {

            var criteriaType = this.model.get("criteriaType");

            if(criteriaType === "simple") {
                return this._loadPreviewTestPlanWithSimpleCriteria();
            } else if(criteriaType === "advanced") {
                return this._loadPreviewTestPlanWithAdvancedCriteria();
            }

        },

        _loadPreviewTestPlanWithSimpleCriteria: function() {

            var simpleCriteria = this.model.get("simpleCriteria");

            var iterationId = this.model.get("replicationParameters").iterationId;
            var replicationParameters = this.model.get("replicationParameters");

            var simpleCriteria = {
                iterationId: iterationId,
                keepTestSuites: replicationParameters.keepTestSuites,
                keepAssignees: replicationParameters.keepAssignees,
                keepFailed: simpleCriteria.keepFailed,
                keepBlocked: simpleCriteria.keepBlocked,
                keepIssued: simpleCriteria.keepIssued,
                keepNonRegression: simpleCriteria.keepNonRegression
            }

                var dataString = JSON.stringify(simpleCriteria);

                return $.ajax({
                    method: "POST",
                    contentType: "application/json",
                    url: squashtm.app.contextRoot + "campaign-assistant/iteration-replication/preview",
                    data: dataString
                });
        },

        _loadPreviewTestPlanWithAdvancedCriteria: function() {

            var advancedCriteria = this.model.get("advancedCriteria");

            var iterationId = this.model.get("replicationParameters").iterationId;
            var replicationParameters = this.model.get("replicationParameters");

            var advancedCriteria = {
                iterationId: iterationId,

                keepTestSuites: replicationParameters.keepTestSuites,
                keepAssignees: replicationParameters.keepAssignees,

                testCaseStatuses: advancedCriteria.testCaseStatuses || [],
                testCaseImportances: advancedCriteria.testCaseImportances || [],
                testCaseNatures: advancedCriteria.testCaseNatures || [],
                testCaseTypes: advancedCriteria.testCaseTypes || [],

                requirementCriticalities: advancedCriteria.requirementCriticalities || [],
                requirementStatuses: advancedCriteria.requirementStatuses || [],
                requirementCategories: advancedCriteria.requirementCategories || [],

                executionStatuses: advancedCriteria.executionStatuses || [],
                executionUsers: advancedCriteria.executionUsers || [],
                executionFromDate: advancedCriteria.executionFromDate,
                executionToDate: advancedCriteria.executionToDate,
                executionModes: advancedCriteria.executionModes || [],

                testSuites: advancedCriteria.testSuites || []
            }

            var dataString = JSON.stringify(advancedCriteria);

            return $.ajax({
                method: "POST",
                contentType: "application/json",
                url: squashtm.app.contextRoot + "/campaign-assistant/iteration-replication/advanced-preview",
                data: dataString
            });
        }

	});

	return previewStepView;

});
