/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.nio.protocol;

import java.io.IOException;
import java.util.concurrent.Future;
import jiracloud.org.apache.http.ConnectionReuseStrategy;
import jiracloud.org.apache.http.HttpException;
import jiracloud.org.apache.http.HttpHost;
import jiracloud.org.apache.http.HttpRequest;
import jiracloud.org.apache.http.HttpResponse;
import jiracloud.org.apache.http.concurrent.BasicFuture;
import jiracloud.org.apache.http.concurrent.FutureCallback;
import jiracloud.org.apache.http.nio.ContentDecoder;
import jiracloud.org.apache.http.nio.ContentEncoder;
import jiracloud.org.apache.http.nio.IOControl;
import jiracloud.org.apache.http.nio.protocol.HttpAsyncRequestExecutionHandler;
import jiracloud.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import jiracloud.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import jiracloud.org.apache.http.params.HttpParams;
import jiracloud.org.apache.http.protocol.HttpContext;
import jiracloud.org.apache.http.protocol.HttpProcessor;
import jiracloud.org.apache.http.util.Args;

@Deprecated
public class BasicAsyncRequestExecutionHandler<T>
implements HttpAsyncRequestExecutionHandler<T> {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final BasicFuture<T> future;
    private final HttpContext localContext;
    private final HttpProcessor httpPocessor;
    private final ConnectionReuseStrategy reuseStrategy;
    private volatile boolean requestSent;

    public BasicAsyncRequestExecutionHandler(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback, HttpContext localContext, HttpProcessor httpPocessor, ConnectionReuseStrategy reuseStrategy, HttpParams params) {
        Args.notNull(requestProducer, "Request producer");
        Args.notNull(responseConsumer, "Response consumer");
        Args.notNull(localContext, "HTTP context");
        Args.notNull(httpPocessor, "HTTP processor");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(params, "HTTP parameters");
        this.requestProducer = requestProducer;
        this.responseConsumer = responseConsumer;
        this.future = new BasicFuture<T>(callback);
        this.localContext = localContext;
        this.httpPocessor = httpPocessor;
        this.reuseStrategy = reuseStrategy;
    }

    public BasicAsyncRequestExecutionHandler(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext localContext, HttpProcessor httpPocessor, ConnectionReuseStrategy reuseStrategy, HttpParams params) {
        this(requestProducer, responseConsumer, null, localContext, httpPocessor, reuseStrategy, params);
    }

    public Future<T> getFuture() {
        return this.future;
    }

    private void releaseResources() {
        try {
            this.responseConsumer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.requestProducer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.releaseResources();
        if (!this.future.isDone()) {
            this.future.cancel();
        }
    }

    @Override
    public HttpHost getTarget() {
        return this.requestProducer.getTarget();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        return this.requestProducer.generateRequest();
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        this.requestProducer.produceContent(encoder, ioControl);
    }

    @Override
    public void requestCompleted(HttpContext context) {
        this.requestProducer.requestCompleted(context);
        this.requestSent = true;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public void resetRequest() {
    }

    @Override
    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        this.responseConsumer.responseReceived(response);
    }

    @Override
    public void consumeContent(ContentDecoder decoder, IOControl ioControl) throws IOException {
        this.responseConsumer.consumeContent(decoder, ioControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Exception ex) {
        try {
            if (!this.requestSent) {
                this.requestProducer.failed(ex);
            }
            this.responseConsumer.failed(ex);
        }
        finally {
            try {
                this.future.failed(ex);
            }
            finally {
                this.releaseResources();
            }
        }
    }

    @Override
    public boolean cancel() {
        try {
            boolean cancelled = this.responseConsumer.cancel();
            this.future.cancel();
            this.releaseResources();
            return cancelled;
        }
        catch (RuntimeException ex) {
            this.failed(ex);
            throw ex;
        }
    }

    @Override
    public void responseCompleted(HttpContext context) {
        try {
            this.responseConsumer.responseCompleted(context);
            T result = this.responseConsumer.getResult();
            Exception ex = this.responseConsumer.getException();
            if (ex == null) {
                this.future.completed(result);
            } else {
                this.future.failed(ex);
            }
            this.releaseResources();
        }
        catch (RuntimeException ex) {
            this.failed(ex);
            throw ex;
        }
    }

    @Override
    public T getResult() {
        return this.responseConsumer.getResult();
    }

    @Override
    public Exception getException() {
        return this.responseConsumer.getException();
    }

    @Override
    public HttpContext getContext() {
        return this.localContext;
    }

    @Override
    public HttpProcessor getHttpProcessor() {
        return this.httpPocessor;
    }

    @Override
    public ConnectionReuseStrategy getConnectionReuseStrategy() {
        return this.reuseStrategy;
    }

    @Override
    public boolean isDone() {
        return this.responseConsumer.isDone();
    }
}

