/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.synchronisation.service;

import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.plugin.workflow.automjira.client.JiraClient;
import org.squashtest.tm.plugin.workflow.automjira.domain.TestCaseToSynchronize;
import org.squashtest.tm.plugin.workflow.automjira.exception.AutomJiraException;
import org.squashtest.tm.plugin.workflow.automjira.repository.SynchronisationDao;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.IssueProcessingHelperService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationJiraToSquashService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationSquashToJiraServiceImpl;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Status;

@Service
@Transactional
public class SynchronizationJiraToSquashServiceImpl
implements SynchronizationJiraToSquashService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationSquashToJiraServiceImpl.class);
    private final IssueProcessingHelperService issueProcessingHelperService;
    private final PlatformTransactionManager transactionManager;
    private final SynchronisationDao syncDao;
    private final Provider<JiraClient> provider;
    private final BugTrackerFinderService serverFinder;
    private final AutomationRequestModificationService automationRequestModificationService;
    private final GenericProjectManagerService projectManager;

    public SynchronizationJiraToSquashServiceImpl(IssueProcessingHelperService issueProcessingHelperService, PlatformTransactionManager transactionManager, SynchronisationDao syncDao, Provider<JiraClient> provider, BugTrackerFinderService serverFinder, AutomationRequestModificationService automationRequestModificationService, GenericProjectManagerService projectManager) {
        this.issueProcessingHelperService = issueProcessingHelperService;
        this.transactionManager = transactionManager;
        this.syncDao = syncDao;
        this.provider = provider;
        this.serverFinder = serverFinder;
        this.automationRequestModificationService = automationRequestModificationService;
        this.projectManager = projectManager;
    }

    @Override
    public void synchronizationJiraToSquash(List<TestCaseToSynchronize> listTcToCanBeSynchronized, RemoteSynchronisation remoteSynchronisation) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Start synchronization Jira to squash");
        }
        Project project = remoteSynchronisation.getProject();
        Map conf = this.projectManager.getPluginConfiguration(project.getId().longValue(), WorkspaceType.TEST_CASE_WORKSPACE, "henix.plugin.automation.workflow.automjira");
        String configuredFinalState = (String)conf.get("finalState");
        TransactionStatus transaction = this.issueProcessingHelperService.createTransaction();
        try {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (JiraClient jiraClient = (JiraClient)this.provider.get();){
                    Long serverId = remoteSynchronisation.getServer().getId();
                    BugTracker bugtracker = this.serverFinder.findById(serverId.longValue());
                    jiraClient.jiraClientAuthentication(bugtracker);
                    List<String> listIssueKey = this.findIssueKeyToSynchronize(listTcToCanBeSynchronized);
                    if (listIssueKey.size() != 0) {
                        this.doSynchronisation(remoteSynchronisation, listIssueKey, configuredFinalState, jiraClient);
                    }
                    this.transactionManager.commit(transaction);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[AUTOM-JIRA-SYNC] -  Finished Synchronisation Jira to Squash with success from remoteSynchronization:" + remoteSynchronisation.getId());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                this.transactionManager.rollback(transaction);
                LOGGER.error("[AUTOM-JIRA-SYNC] - Project id: {} name: {} - Synchronisation id: {} name: {} - Server id: {} name: {} - Error while synchronizing Jira to Squash.", new Object[]{remoteSynchronisation.getProject().getId(), remoteSynchronisation.getProject().getName(), remoteSynchronisation.getId(), remoteSynchronisation.getName(), remoteSynchronisation.getServer().getId(), e});
                throw new AutomJiraException("[AUTOM-JIRA-SYNC] - Error while synchronizing Jira to Squash from remoteSynchronization:" + remoteSynchronisation.getId(), e);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[AUTOM-JIRA-SYNC] - Finished synchronization Jira to Squash.");
            }
        }
    }

    @Override
    public void doSynchronisation(RemoteSynchronisation remoteSynchronisation, List<String> listIssueKey, String configuredFinalState, JiraClient jiraClient) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Synchronisation update status test case and RemoteAutomationRequestExtender ");
        }
        List<Issue> listRemoteIssue = jiraClient.getListIssueByKey(listIssueKey);
        List<String> keys = listRemoteIssue.stream().map(BasicIssue::getKey).collect(Collectors.toList());
        List<RemoteAutomationRequestExtender> ListRares = this.syncDao.findListRareByIssueKey(keys);
        this.updateRemoteAutomationRequestExtenderAndStatus(listRemoteIssue, ListRares, configuredFinalState);
    }

    @Override
    public void updateRemoteAutomationRequestExtenderAndStatus(List<Issue> listIssuesJira, List<RemoteAutomationRequestExtender> ListRares, String configuredFinalState) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Synchronisation update RemoteAutomationRequestExtender");
        }
        Date dateSync = new Date();
        List<String> keys = listIssuesJira.stream().map(BasicIssue::getKey).collect(Collectors.toList());
        List<RemoteAutomationRequestExtender> rares = this.syncDao.findListRareByIssueKey(keys);
        ArrayList eligibleToScriptAssociationTestCaseIds = new ArrayList();
        listIssuesJira.forEach(issueJira -> {
            for (RemoteAutomationRequestExtender rare : rares) {
                if (!issueJira.getKey().equals(rare.getRemoteIssueKey())) continue;
                String assignee = issueJira.getAssignee() != null ? issueJira.getAssignee().getDisplayName() : "";
                rare.setRemoteAssignedTo(assignee);
                this.updateStatus((Issue)issueJira, rare, configuredFinalState, eligibleToScriptAssociationTestCaseIds);
                rare.setLastSyncDate(dateSync);
            }
        });
        if (!eligibleToScriptAssociationTestCaseIds.isEmpty()) {
            this.automationRequestModificationService.updateTAScript(eligibleToScriptAssociationTestCaseIds);
        }
    }

    private List<String> findIssueKeyToSynchronize(List<TestCaseToSynchronize> listTestCaseToSynchronize) {
        ArrayList<String> listIssueKey = new ArrayList<String>();
        listTestCaseToSynchronize.forEach(tcToSync -> {
            String remoteIssueKey = tcToSync.getRemoteIssueKey();
            String newRemoteStatusIssue = tcToSync.getNewRemoteStatusIssue() != null ? tcToSync.getNewRemoteStatusIssue() : "";
            String newRemoteAssignedTo = tcToSync.getNewRemoteAssignedTo() != null ? tcToSync.getNewRemoteAssignedTo() : "";
            RemoteAutomationRequestExtender rare = tcToSync.getRemoteAutomationRequestExtender();
            if (!rare.getRemoteRequestStatus().equalsIgnoreCase(newRemoteStatusIssue) || !rare.getRemoteAssignedTo().equalsIgnoreCase(newRemoteAssignedTo)) {
                listIssueKey.add(remoteIssueKey);
            }
        });
        return listIssueKey;
    }

    private void updateStatus(Issue issueJira, RemoteAutomationRequestExtender rare, String configuredFinalState, List<Long> eligibleToScriptAssociationTestCaseIds) {
        Status status = issueJira.getStatus();
        rare.setRemoteRequestStatus(status.getName());
        TestCase testCase = rare.getAutomationRequest().getTestCase();
        if (status.getName().equalsIgnoreCase(configuredFinalState)) {
            this.automationRequestModificationService.changeAutomationRequestStatus(Collections.singletonList(testCase.getId()), AutomationRequestStatus.AUTOMATED);
            eligibleToScriptAssociationTestCaseIds.add(testCase.getId());
        } else {
            this.automationRequestModificationService.changeAutomationRequestStatus(Collections.singletonList(testCase.getId()), AutomationRequestStatus.AUTOMATION_IN_PROGRESS);
        }
    }
}

