/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Provider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.domain.tf.automationrequest.SynchronizableIssueStatus;
import org.squashtest.tm.plugin.workflow.automjira.client.JiraClient;
import org.squashtest.tm.plugin.workflow.automjira.domain.CustomFieldInfo;
import org.squashtest.tm.plugin.workflow.automjira.helpers.LocaleWithFallback;
import org.squashtest.tm.plugin.workflow.automjira.repository.SynchronisationDao;
import org.squashtest.tm.plugin.workflow.automjira.service.JiraAutomationWorkflowPluginService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.IssueProcessingHelperService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.RemoteIssueFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.internal.repository.CustomTestCaseDao;
import org.squashtest.tm.service.internal.repository.RemoteAutomationRequestExtenderDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Status;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.input.IssueInput;

@Service
public class JiraAutomationWorkflowPluginServiceImpl
implements JiraAutomationWorkflowPluginService {
    private static final String SERVER_FOR_PROJECT = "serverForProject";
    private static final String FINAL_STATE = "finalState";
    private static final String PROJECT_JIRA = "projectKey";
    private static final String REQUEST_TYPE = "requestType";
    private static final String LIST_CUFS = "listCufs";
    private static final String PLUGIN_ID = "henix.plugin.automation.workflow.automjira";
    private static final String PLUGIN_NAME = "henix.plugin.automation.workflow.automjira";
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraAutomationWorkflowPluginServiceImpl.class);
    private final Provider<JiraClient> provider;
    private final InternationalizationHelper i18nHelper;
    private final CustomTestCaseDao testCaseDao;
    private final BugTrackerFinderService serverFinder;
    private final RemoteAutomationRequestExtenderDao remoteRequestAutomationExtenderDao;
    private final GenericProjectManagerService projectManager;
    private final SynchronisationDao syncDao;
    private final RemoteIssueFinderService remoteIssueFinderService;
    private final Locale locale;
    private final IssueProcessingHelperService issueProcessingHelperService;

    public JiraAutomationWorkflowPluginServiceImpl(Provider<JiraClient> provider, InternationalizationHelper i18nHelper, CustomTestCaseDao testCaseDao, BugTrackerFinderService serverFinder, RemoteAutomationRequestExtenderDao remoteRequestAutomationExtenderDao, GenericProjectManagerService projectManager, SynchronisationDao syncDao, RemoteIssueFinderService remoteIssueFinderService, IssueProcessingHelperService issueProcessingHelperService) {
        this.provider = provider;
        this.i18nHelper = i18nHelper;
        this.testCaseDao = testCaseDao;
        this.serverFinder = serverFinder;
        this.remoteRequestAutomationExtenderDao = remoteRequestAutomationExtenderDao;
        this.projectManager = projectManager;
        this.syncDao = syncDao;
        this.remoteIssueFinderService = remoteIssueFinderService;
        this.locale = LocaleWithFallback.getLocaleWithFallback();
        this.issueProcessingHelperService = issueProcessingHelperService;
    }

    @Override
    public String createNewTicketRemoteServer(Long testCaseId) throws IOException {
        TestCase testCase = (TestCase)this.testCaseDao.findById(testCaseId.longValue());
        Map pluginConfiguration = this.projectManager.getPluginConfigurationWithoutCheck(testCase.getProject().getId().longValue(), WorkspaceType.TEST_CASE_WORKSPACE, "henix.plugin.automation.workflow.automjira");
        if (pluginConfiguration.isEmpty()) {
            String msg = this.i18nHelper.internationalize("automation.workflow.jira.message.erreur.configuration", this.locale) + ": " + this.i18nHelper.internationalize("henix.plugin.automation.workflow.automjira", this.locale);
            throw new PluginValidationException(msg);
        }
        long serverId = Long.parseLong((String)pluginConfiguration.get(SERVER_FOR_PROJECT));
        BugTracker bugtracker = this.serverFinder.findById(serverId);
        AutomationRequest automationRequest = testCase.getAutomationRequest();
        if (automationRequest == null) {
            return null;
        }
        if (automationRequest.getRemoteAutomationRequestExtender() != null) {
            RemoteAutomationRequestExtender rare = automationRequest.getRemoteAutomationRequestExtender();
            Issue issue = this.remoteIssueFinderService.findRemoteIssueByKey(rare.getRemoteIssueKey(), bugtracker);
            if (issue == null || this.isIssueAutomated(issue.getStatus(), rare.getSynchronizableIssueStatus(), (String)pluginConfiguration.get(FINAL_STATE))) {
                this.syncDao.removeRemoteAutomationRequestExtender(rare);
            } else {
                LOGGER.debug("[AUTOM-JIRA-TICKET-CREATION] - The ticket already exists;");
                return null;
            }
        }
        String remoteIssueKey = this.createNewTicketJira(bugtracker, pluginConfiguration, testCase);
        return remoteIssueKey;
    }

    @Override
    public void createRemoteAutomationRequestExtenderForTestCaseIfNotExist(String remoteIssueKey, Long testCaseId) throws JsonProcessingException {
        TestCase testCase = (TestCase)this.testCaseDao.findById(testCaseId.longValue());
        JiraClient jiraClient = (JiraClient)this.provider.get();
        AutomationRequest automationRequest = testCase.getAutomationRequest();
        if (automationRequest == null) {
            String msgError = this.i18nHelper.internationalize("workflow.automation.jira.error.automation.request.null", this.locale);
            throw new Error(msgError);
        }
        if (automationRequest.getRemoteAutomationRequestExtender() != null) {
            LOGGER.debug("[AUTOM-JIRA-TICKET-CREATION] - Extender already exists");
            return;
        }
        try {
            try {
                Map conf = this.projectManager.getPluginConfigurationWithoutCheck(testCase.getProject().getId().longValue(), WorkspaceType.TEST_CASE_WORKSPACE, "henix.plugin.automation.workflow.automjira");
                BugTracker bugtracker = this.serverFinder.findById(Long.parseLong((String)conf.get(SERVER_FOR_PROJECT)));
                RemoteAutomationRequestExtender remoteRequestExtender = new RemoteAutomationRequestExtender();
                jiraClient.jiraClientAuthentication(bugtracker);
                Issue issueJira = jiraClient.getIssueJira(remoteIssueKey);
                this.saveRemoteAutomRequestExtender(remoteRequestExtender, testCase, issueJira, bugtracker, jiraClient);
                testCase.getAutomationRequest().setRemoteAutomationRequestExtender(remoteRequestExtender);
            }
            catch (BugTrackerNoCredentialsException ex) {
                String message = this.i18nHelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", this.locale);
                throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
            }
        }
        finally {
            if (jiraClient != null) {
                jiraClient.close();
            }
        }
    }

    private String createNewTicketJira(BugTracker bugtracker, Map<String, String> pluginConfiguration, TestCase testCase) throws IOException {
        String remoteIssueKey;
        List listCufInfo = null;
        Long issueTypeId = Long.valueOf(pluginConfiguration.get(REQUEST_TYPE));
        String projectKey = pluginConfiguration.get(PROJECT_JIRA);
        try {
            Throwable throwable = null;
            Object var11_10 = null;
            try (JiraClient jiraClient = (JiraClient)this.provider.get();){
                if (pluginConfiguration.get(LIST_CUFS) != null) {
                    listCufInfo = (List)new ObjectMapper().readValue(pluginConfiguration.get(LIST_CUFS), (TypeReference)new TypeReference<List<CustomFieldInfo>>(){});
                }
                jiraClient.jiraClientAuthentication(bugtracker);
                IssueInput issueInput = jiraClient.getIssueInput(projectKey, issueTypeId, testCase, listCufInfo);
                BasicIssue remoteIssue = jiraClient.createIssue(issueInput);
                remoteIssueKey = remoteIssue.getKey();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BugTrackerNoCredentialsException ex) {
            String message = this.i18nHelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", this.locale);
            throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
        }
        return remoteIssueKey;
    }

    private void saveRemoteAutomRequestExtender(RemoteAutomationRequestExtender remoteRequestExtender, TestCase testCase, Issue issueJira, BugTracker bugtracker, JiraClient jiraClient) throws JsonProcessingException {
        String valueSentForSync = this.issueProcessingHelperService.getValueSentForSync(testCase);
        remoteRequestExtender.setAutomationRequest(testCase.getAutomationRequest());
        remoteRequestExtender.setRemoteIssueKey(issueJira.getKey());
        remoteRequestExtender.setRemoteRequestStatus(issueJira.getStatus() != null ? issueJira.getStatus().getName() : "N/A");
        try {
            remoteRequestExtender.setRemoteRequestUrl(jiraClient.makeViewIssueUrl(bugtracker, issueJira).toString());
        }
        catch (MalformedURLException malformedURLException) {
            remoteRequestExtender.setRemoteRequestUrl(issueJira.getSelf().toString());
        }
        remoteRequestExtender.setRemoteAssignedTo(issueJira.getAssignee() != null ? issueJira.getAssignee().getDisplayName() : "N/A");
        remoteRequestExtender.setServer(bugtracker);
        remoteRequestExtender.setAutomationRequest(testCase.getAutomationRequest());
        remoteRequestExtender.setSentValueForSync(valueSentForSync);
        this.remoteRequestAutomationExtenderDao.save((Object)remoteRequestExtender);
    }

    private boolean isIssueAutomated(Status issueStatus, SynchronizableIssueStatus rareSynchronizableIssueStatus, String pluginConfigurationStatus) {
        return issueStatus != null && rareSynchronizableIssueStatus != null && pluginConfigurationStatus != null && SynchronizableIssueStatus.TO_SYNCHRONIZE.equals((Object)rareSynchronizableIssueStatus) && pluginConfigurationStatus.equalsIgnoreCase(issueStatus.getName());
    }
}

