/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.internal.RedmineJSONParser;
import com.taskadapter.redmineapi.internal.json.JsonInput;
import com.taskadapter.redmineapi.internal.json.JsonObjectParser;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONArray;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONException;
import org.squashtest.tm.plugin.bugtracker.redmine3.json.JSONObject;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedUser;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedWorkflows;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.PermissionRule;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.WorkFlowGroup;

public final class ExtendedRedmine3JsonParser
extends RedmineJSONParser {
    public static final JsonObjectParser<CustomField> CUSTOM_FIELD_PARSER = new JsonObjectParser<CustomField>(){

        @Override
        public CustomField parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseCustomField(input);
        }
    };
    public static final JsonObjectParser<Tracker> TRACKER_PARSER = new JsonObjectParser<Tracker>(){

        @Override
        public Tracker parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseTracker(input);
        }
    };
    public static final JsonObjectParser<Role> ROLE_PARSER = new JsonObjectParser<Role>(){

        @Override
        public Role parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseRole(input);
        }
    };
    public static final JsonObjectParser<ExtendedWorkflows> WORKFLOW_PARSER = new JsonObjectParser<ExtendedWorkflows>(){

        @Override
        public ExtendedWorkflows parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseWorkflows(input);
        }
    };
    public static final JsonObjectParser<Membership> MEMBERSHIP_PARSER = new JsonObjectParser<Membership>(){

        @Override
        public Membership parse(JSONObject input) throws JSONException {
            return ExtendedRedmine3JsonParser.parseMembership(input);
        }
    };

    private ExtendedRedmine3JsonParser() {
    }

    public static Role parseRole(JSONObject content) throws JSONException {
        ExtendedRole result = new ExtendedRole();
        int id = JsonInput.getInt(content, "id");
        String name = JsonInput.getStringNotNull(content, "name");
        result.setId(id);
        result.setName(name);
        result.setAssignable(JsonInput.getOptionalBool(content, "assignable"));
        return result;
    }

    public static Tracker parseTracker(JSONObject content) throws JSONException {
        ExtendedTracker result = new ExtendedTracker();
        int id = JsonInput.getInt(content, "id");
        String name = JsonInput.getStringNotNull(content, "name");
        result.setId(id);
        result.setName(name);
        result.setCoreFields(ExtendedRedmine3JsonParser.getList(content, "core_fields"));
        JSONArray tmp = JsonInput.getArrayOrNull(content, "custom_fields");
        ArrayList<ExtendedCustomField> customFields = new ArrayList<ExtendedCustomField>();
        int i = 0;
        while (i < tmp.length()) {
            ExtendedCustomField custom = ExtendedRedmine3JsonParser.parseCustomField(tmp.getJSONObject(i));
            customFields.add(custom);
            ++i;
        }
        result.setCustomFields(customFields);
        return result;
    }

    private static List<String> getList(JSONObject content, String name) throws JSONException {
        JSONArray tmp = JsonInput.getArrayOrNull(content, name);
        ArrayList<String> strings = new ArrayList<String>();
        int i = 0;
        while (i < tmp.length()) {
            strings.add(String.valueOf(tmp.get(i)));
            ++i;
        }
        return strings;
    }

    public static ExtendedCustomField parseCustomField(JSONObject content) throws JSONException {
        ExtendedCustomField result = new ExtendedCustomField();
        ExtendedRedmine3JsonParser.setCustomFieldFields(result, content);
        JSONArray jsonProjects = JsonInput.getArrayOrNull(content, "projects");
        if (jsonProjects != null) {
            ArrayList<Project> projects = new ArrayList<Project>();
            int i = 0;
            while (i < jsonProjects.length()) {
                Project project = ExtendedRedmine3JsonParser.parseMinimalProject(jsonProjects.getJSONObject(i));
                projects.add(project);
                ++i;
            }
            result.setProject(projects);
        }
        if (JsonInput.getArrayOrNull(content, "possible_values") != null) {
            ArrayList<String> strings = new ArrayList<String>();
            JSONArray tmp = JsonInput.getArrayOrNull(content, "possible_values");
            int i = 0;
            while (i < tmp.length()) {
                strings.add(JsonInput.getStringOrEmpty((JSONObject)tmp.get(i), "value"));
                ++i;
            }
            result.setPossibleValues(strings);
        }
        if (JsonInput.getStringOrNull(content, "default_value") != null) {
            String defaultValue = JsonInput.getStringOrNull(content, "default_value");
            result.setDefaultValue(defaultValue);
        }
        ArrayList<String> versionStatuses = new ArrayList<String>();
        JSONArray versionStatusArray = JsonInput.getArrayOrNull(content, "version_status");
        if (versionStatusArray != null) {
            int i = 0;
            while (i < versionStatusArray.length()) {
                versionStatuses.add(versionStatusArray.getString(i));
                ++i;
            }
        }
        result.setVersionStatuses(versionStatuses);
        return result;
    }

    private static void setCustomFieldFields(ExtendedCustomField result, JSONObject content) throws JSONException {
        result.setId(JsonInput.getInt(content, "id"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        result.setCustomizedType(JsonInput.getStringOrNull(content, "customized_type"));
        result.setFieldFormat(JsonInput.getStringOrNull(content, "field_format"));
        result.setRequired(JsonInput.getOptionalBool(content, "is_required"));
        result.setAvailableForAllProject(JsonInput.getOptionalBool(content, "is_for_all"));
        result.setMultiple(JsonInput.getOptionalBool(content, "multiple"));
    }

    public static ExtendedWorkflows parseWorkflows(JSONObject content) throws JSONException {
        ExtendedWorkflows extendedWorkflows = new ExtendedWorkflows();
        if (!content.has("extended_workflows")) {
            return extendedWorkflows;
        }
        JSONArray workflowGroupsArray = content.getJSONArray("extended_workflows");
        ArrayList<WorkFlowGroup> workflowGroupsList = new ArrayList<WorkFlowGroup>();
        int i = 0;
        while (i < workflowGroupsArray.length()) {
            JSONObject groupJson = workflowGroupsArray.getJSONObject(i);
            WorkFlowGroup group = new WorkFlowGroup();
            group.setTrackerName(groupJson.getString("tracker_name"));
            JSONArray permissionsArray = groupJson.getJSONArray("permissions");
            ArrayList<PermissionRule> permissionRulesList = new ArrayList<PermissionRule>();
            int j = 0;
            while (j < permissionsArray.length()) {
                JSONObject permissionJson = permissionsArray.getJSONObject(j);
                PermissionRule rule = new PermissionRule();
                rule.setFieldName(permissionJson.getString("field_name"));
                rule.setRule(permissionJson.getString("rule"));
                permissionRulesList.add(rule);
                ++j;
            }
            group.setPermissions(permissionRulesList);
            workflowGroupsList.add(group);
            ++i;
        }
        extendedWorkflows.setWorkFlowGroups(workflowGroupsList);
        return extendedWorkflows;
    }

    public static Membership parseMembership(JSONObject content) throws JSONException {
        Membership result = new Membership();
        result.setId(JsonInput.getIntOrNull(content, "id"));
        result.setProject((Project)JsonInput.getObjectOrNull(content, "project", MINIMAL_PROJECT_PARSER));
        if (content.has("user")) {
            User user = (User)JsonInput.getObjectOrNull(content, "user", USER_PARSER);
            result.setUser(user);
        } else if (content.has("group")) {
            User user = (User)JsonInput.getObjectOrNull(content, "group", USER_PARSER);
            ExtendedUser extendedUser = new ExtendedUser(user, true);
            if (extendedUser.getLastName() == null) {
                extendedUser.setLastName("");
            }
            result.setUser(extendedUser);
        }
        result.setRoles(JsonInput.getListOrEmpty(content, "roles", ROLE_PARSER));
        return result;
    }
}

