/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.operations;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.User;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.Redmine3RestClientOperation;

public class SearchPossibleReporter
extends Redmine3RestClientOperation<List<User>> {
    private static final String ADD_ISSUES = "add_issues";
    private final String userId;
    private final List<Membership> members;

    public SearchPossibleReporter(RedmineManager manager, String userId, List<Membership> members) {
        super(manager);
        this.userId = userId;
        this.members = members;
    }

    @Override
    public List<User> doIt() throws RedmineException {
        ArrayList<User> users = new ArrayList<User>(this.members.size());
        ArrayList<Membership> memberships = new ArrayList<Membership>();
        for (Membership member : this.members) {
            User user = member.getUser();
            if (user == null || user.getFullName() == null || !user.getId().toString().equals(this.userId) || !this.userCanSubmitIssue(member)) continue;
            memberships.add(member);
            user.setMemberships(memberships);
            users.add(user);
        }
        return users;
    }

    private boolean userCanSubmitIssue(Membership member) throws RedmineException {
        List<Role> roles = member.getRoles();
        for (Role r : roles) {
            Role role = this.manager.getRoleById(r.getId());
            if (!role.getPermissions().contains(ADD_ISSUES)) continue;
            return true;
        }
        return false;
    }
}

